/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.usecasemaid;

import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.api.InjectorConfiguration;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.usecasemaid.Invocation;
import de.quantummaid.usecasemaid.InvocationId;
import de.quantummaid.usecasemaid.UseCaseMaid;
import de.quantummaid.usecasemaid.UseCases;
import de.quantummaid.usecasemaid.driver.ExecutionDriver;
import de.quantummaid.usecasemaid.driver.SimpleExecutionDriver;
import de.quantummaid.usecasemaid.serializing.SerializerAndDeserializer;
import de.quantummaid.usecasemaid.serializing.UseCaseClassScanner;
import de.quantummaid.usecasemaid.sideeffects.SideEffectExecutor;
import de.quantummaid.usecasemaid.sideeffects.SideEffectRegistration;
import de.quantummaid.usecasemaid.sideeffects.SideEffectsSystem;
import de.quantummaid.usecasemaid.usecasemethod.UseCaseMethod;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;

public final class UseCaseMaidBuilder {
    private final ReflectMaid reflectMaid;
    private final List<GenericType<?>> useCases = new ArrayList();
    private final List<SideEffectRegistration> sideEffectRegistrations = new ArrayList<SideEffectRegistration>();
    private ExecutionDriver executionDriver = SimpleExecutionDriver.simpleExecutionDriver();
    private final List<Recipe> mapperConfigurations = new ArrayList<Recipe>();
    private final List<InjectorConfiguration> dependencies = new ArrayList<InjectorConfiguration>();
    private final List<InjectorConfiguration> invocationScopedDependencies = new ArrayList<InjectorConfiguration>();

    static UseCaseMaidBuilder useCaseMaidBuilder(ReflectMaid reflectMaid) {
        return new UseCaseMaidBuilder(reflectMaid);
    }

    public UseCaseMaidBuilder invoking(Class<?> useCase) {
        GenericType genericType = GenericType.genericType(useCase);
        return this.invoking(genericType);
    }

    public UseCaseMaidBuilder invoking(GenericType<?> useCase) {
        this.useCases.add(useCase);
        return this;
    }

    public <S> UseCaseMaidBuilder withSideEffects(Class<S> sideEffectType, SideEffectExecutor<S> sideEffectExecutor) {
        GenericType genericType = GenericType.genericType(sideEffectType);
        return this.withSideEffects(genericType, sideEffectExecutor);
    }

    public <S> UseCaseMaidBuilder withSideEffects(GenericType<S> sideEffectType, SideEffectExecutor<S> sideEffectExecutor) {
        SideEffectRegistration sideEffectRegistration = SideEffectRegistration.sideEffectRegistration(sideEffectType, sideEffectExecutor);
        this.sideEffectRegistrations.add(sideEffectRegistration);
        return this;
    }

    public UseCaseMaidBuilder withExecutionDriver(ExecutionDriver executionDriver) {
        NotNullValidator.validateNotNull((Object)executionDriver, (String)"executionDriver");
        this.executionDriver = executionDriver;
        return this;
    }

    public UseCaseMaidBuilder withMapperConfiguration(Recipe mapperConfiguration) {
        NotNullValidator.validateNotNull((Object)mapperConfiguration, (String)"mapperConfiguration");
        this.mapperConfigurations.add(mapperConfiguration);
        return this;
    }

    public UseCaseMaidBuilder withDependencies(InjectorConfiguration module) {
        this.dependencies.add(module);
        return this;
    }

    public UseCaseMaidBuilder withInvocationScopedDependencies(InjectorConfiguration module) {
        this.invocationScopedDependencies.add(module);
        return this;
    }

    public UseCaseMaid build() {
        LinkedHashMap<ResolvedType, UseCaseMethod> useCaseMethods = new LinkedHashMap<ResolvedType, UseCaseMethod>();
        InjectMaidBuilder injectMaidBuilder = InjectMaid.anInjectMaid((ReflectMaid)this.reflectMaid);
        MapMaidBuilder mapMaidBuilder = MapMaid.aMapMaid((ReflectMaid)this.reflectMaid);
        this.dependencies.forEach(arg_0 -> ((InjectMaidBuilder)injectMaidBuilder).withConfiguration(arg_0));
        injectMaidBuilder.withScope(Invocation.class, builder -> {
            builder.withCustomType(InvocationId.class, Invocation.class, Invocation::id);
            this.invocationScopedDependencies.forEach(arg_0 -> ((InjectMaidBuilder)builder).withConfiguration(arg_0));
            this.useCases.forEach(type -> {
                ResolvedType resolvedType = this.reflectMaid.resolve(type);
                UseCaseMethod useCaseMethod = UseCaseMethod.useCaseMethodOf(resolvedType);
                useCaseMethods.put(resolvedType, useCaseMethod);
                UseCaseClassScanner.addMethod(useCaseMethod, mapMaidBuilder);
                builder.withType(type);
            });
        });
        LinkedHashMap<ResolvedType, SideEffectRegistration> sideEffectRegistrationMap = new LinkedHashMap<ResolvedType, SideEffectRegistration>();
        this.sideEffectRegistrations.forEach(sideEffectRegistration -> {
            GenericType<?> type = sideEffectRegistration.type();
            mapMaidBuilder.injecting(type);
            ResolvedType resolvedType = this.reflectMaid.resolve(type);
            sideEffectRegistrationMap.put(resolvedType, (SideEffectRegistration)sideEffectRegistration);
        });
        SideEffectsSystem sideEffectsSystem = SideEffectsSystem.sideEffectsSystem(sideEffectRegistrationMap);
        this.mapperConfigurations.forEach(recipe -> recipe.apply(mapMaidBuilder));
        MapMaid mapMaid = mapMaidBuilder.build();
        SerializerAndDeserializer serializerAndDeserializer = SerializerAndDeserializer.serializationAndDeserialization(mapMaid);
        InjectMaid injector = injectMaidBuilder.build();
        return UseCaseMaid.useCaseMaid(this.reflectMaid, UseCases.useCases(useCaseMethods), injector, serializerAndDeserializer, sideEffectsSystem, this.executionDriver);
    }

    @Generated
    private UseCaseMaidBuilder(ReflectMaid reflectMaid) {
        this.reflectMaid = reflectMaid;
    }
}

