/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.usecasemaid;

import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.api.Injector;
import de.quantummaid.injectmaid.timing.InstantiationTime;
import de.quantummaid.injectmaid.timing.TimedInstantiation;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.usecasemaid.Invocation;
import de.quantummaid.usecasemaid.InvocationId;
import de.quantummaid.usecasemaid.ResultAndSideEffects;
import de.quantummaid.usecasemaid.UseCaseMaidBuilder;
import de.quantummaid.usecasemaid.UseCaseResult;
import de.quantummaid.usecasemaid.UseCases;
import de.quantummaid.usecasemaid.driver.ExecutionDriver;
import de.quantummaid.usecasemaid.serializing.SerializerAndDeserializer;
import de.quantummaid.usecasemaid.sideeffects.SideEffectInstance;
import de.quantummaid.usecasemaid.sideeffects.SideEffectsSystem;
import de.quantummaid.usecasemaid.sideeffects.collector.CollectorInstance;
import de.quantummaid.usecasemaid.usecasemethod.UseCaseMethod;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class UseCaseMaid {
    private final ReflectMaid reflectMaid;
    private final UseCases useCases;
    private final InjectMaid instantiator;
    private final SerializerAndDeserializer serializerAndDeserializer;
    private final SideEffectsSystem sideEffectsSystem;
    private final ExecutionDriver executionDriver;

    public static UseCaseMaidBuilder aUseCaseMaid() {
        ReflectMaid reflectMaid = ReflectMaid.aReflectMaid();
        return UseCaseMaid.aUseCaseMaid(reflectMaid);
    }

    public static UseCaseMaidBuilder aUseCaseMaid(ReflectMaid reflectMaid) {
        return UseCaseMaidBuilder.useCaseMaidBuilder(reflectMaid);
    }

    static UseCaseMaid useCaseMaid(ReflectMaid reflectMaid, UseCases useCases, InjectMaid instantiator, SerializerAndDeserializer serializerAndDeserializer, SideEffectsSystem sideEffectsSystem, ExecutionDriver executionDriver) {
        return new UseCaseMaid(reflectMaid, useCases, instantiator, serializerAndDeserializer, sideEffectsSystem, executionDriver);
    }

    public UseCaseResult invoke(Class<?> useCase) {
        GenericType genericType = GenericType.genericType(useCase);
        return this.invoke(genericType);
    }

    public UseCaseResult invoke(GenericType<?> useCase) {
        return this.invoke(useCase, Map.of());
    }

    public UseCaseResult invoke(Class<?> useCase, Map<String, Object> input) {
        GenericType genericType = GenericType.genericType(useCase);
        return this.invoke(genericType, input);
    }

    public UseCaseResult invoke(GenericType<?> useCase, Map<String, Object> input) {
        InvocationId invocationId = InvocationId.randomInvocationId();
        return this.invoke(useCase, input, invocationId);
    }

    public UseCaseResult invoke(Class<?> useCase, Map<String, Object> input, Object additionalData) {
        GenericType genericType = GenericType.genericType(useCase);
        return this.invoke(genericType, input, additionalData);
    }

    public UseCaseResult invoke(GenericType<?> useCase, Map<String, Object> input, Object additionalData) {
        InvocationId invocationId = InvocationId.randomInvocationId();
        return this.invoke(useCase, input, invocationId, additionalData);
    }

    public UseCaseResult invoke(Class<?> useCase, Map<String, Object> input, InvocationId invocationId) {
        GenericType genericType = GenericType.genericType(useCase);
        return this.invoke(genericType, input, invocationId);
    }

    public UseCaseResult invoke(GenericType<?> useCase, Map<String, Object> input, InvocationId invocationId) {
        return this.invoke(useCase, input, invocationId, null);
    }

    public UseCaseResult invoke(Class<?> useCase, Map<String, Object> input, InvocationId invocationId, Object additionalData) {
        GenericType genericType = GenericType.genericType(useCase);
        return this.invoke(genericType, input, invocationId, additionalData);
    }

    public UseCaseResult invoke(GenericType<?> useCase, Map<String, Object> input, InvocationId invocationId, Object additionalData) {
        ResolvedType resolvedType = this.reflectMaid.resolve(useCase);
        UseCaseMethod useCaseMethod = this.useCases.forUseCase(resolvedType);
        List<CollectorInstance<?, ?>> collectorInstances = this.sideEffectsSystem.createCollectorInstances(this.reflectMaid);
        Map<String, Object> parameters = this.serializerAndDeserializer.deserializeParameters(input, useCaseMethod, injector -> collectorInstances.forEach(instance -> injector.put(instance.collectorType(), instance.collectorInstance())));
        Invocation invocation = Invocation.invocation(invocationId, useCaseMethod.useCaseClass(), parameters, additionalData);
        ResultAndSideEffects resultAndSideEffects = this.executionDriver.executeUseCase(invocation, (Injector)this.instantiator, scopedInjector -> {
            GenericType objectType = GenericType.fromResolvedType((ResolvedType)useCaseMethod.useCaseClass());
            TimedInstantiation instanceWithInitializationTime = scopedInjector.getInstanceWithInitializationTime(objectType);
            UseCaseResult result = this.invokeMethod(useCaseMethod, (TimedInstantiation<Object>)instanceWithInitializationTime, parameters);
            List<SideEffectInstance<?>> collectedSideEffects = collectorInstances.stream().map(CollectorInstance::collectInstances).flatMap(Collection::stream).collect(Collectors.toList());
            return ResultAndSideEffects.resultAndSideEffects(result, collectedSideEffects);
        });
        List<SideEffectInstance<?>> sideEffects = resultAndSideEffects.sideEffects();
        this.executionDriver.executeSideEffects(invocation, sideEffects, (Injector)this.instantiator, this.sideEffectsSystem);
        return resultAndSideEffects.result();
    }

    public InjectMaid instantiator() {
        return this.instantiator;
    }

    public MapMaid mapper() {
        return this.serializerAndDeserializer.mapMaid();
    }

    private UseCaseResult invokeMethod(UseCaseMethod useCaseMethod, TimedInstantiation<Object> timedUseCase, Map<String, Object> parameters) {
        Optional<Object> invocationResult;
        Object useCase = timedUseCase.instance();
        InstantiationTime instantiationTime = timedUseCase.instantiationTime();
        try {
            invocationResult = useCaseMethod.invoke(useCase, parameters);
        }
        catch (Throwable e) {
            return UseCaseResult.error(e, instantiationTime);
        }
        return invocationResult.map(returnValue -> {
            ResolvedType returnType = useCaseMethod.returnType().orElseThrow();
            return this.serializerAndDeserializer.serializeReturnValue(returnValue, returnType);
        }).map(returnValue -> UseCaseResult.successfulReturnValue(returnValue, instantiationTime)).orElseGet(() -> UseCaseResult.successfulVoid(instantiationTime));
    }

    @Generated
    private UseCaseMaid(ReflectMaid reflectMaid, UseCases useCases, InjectMaid instantiator, SerializerAndDeserializer serializerAndDeserializer, SideEffectsSystem sideEffectsSystem, ExecutionDriver executionDriver) {
        this.reflectMaid = reflectMaid;
        this.useCases = useCases;
        this.instantiator = instantiator;
        this.serializerAndDeserializer = serializerAndDeserializer;
        this.sideEffectsSystem = sideEffectsSystem;
        this.executionDriver = executionDriver;
    }
}

