/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.usecasemaid;

import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.api.Injector;
import de.quantummaid.injectmaid.api.InjectorConfiguration;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import de.quantummaid.usecasemaid.InvocationId;
import de.quantummaid.usecasemaid.UseCaseMaid;
import de.quantummaid.usecasemaid.UseCases;
import de.quantummaid.usecasemaid.driver.ExecutionDriver;
import de.quantummaid.usecasemaid.driver.SimpleExecutionDriver;
import de.quantummaid.usecasemaid.serializing.SerializerAndDeserializer;
import de.quantummaid.usecasemaid.serializing.UseCaseClassScanner;
import de.quantummaid.usecasemaid.sideeffects.SideEffectExecutor;
import de.quantummaid.usecasemaid.sideeffects.SideEffectRegistration;
import de.quantummaid.usecasemaid.sideeffects.SideEffectsSystem;
import de.quantummaid.usecasemaid.usecasemethod.UseCaseMethod;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;

public final class UseCaseMaidBuilder {
    private final List<GenericType<?>> useCases = new ArrayList();
    private final List<SideEffectRegistration> sideEffectRegistrations = new ArrayList<SideEffectRegistration>();
    private ExecutionDriver executionDriver = SimpleExecutionDriver.simpleExecutionDriver();
    private final List<InjectorConfiguration> dependencies = new ArrayList<InjectorConfiguration>();
    private final List<InjectorConfiguration> invocationScopedDependencies = new ArrayList<InjectorConfiguration>();

    static UseCaseMaidBuilder useCaseMaidBuilder() {
        return new UseCaseMaidBuilder();
    }

    public UseCaseMaidBuilder invoking(Class<?> useCase) {
        GenericType genericType = GenericType.genericType(useCase);
        return this.invoking(genericType);
    }

    public UseCaseMaidBuilder invoking(GenericType<?> useCase) {
        this.useCases.add(useCase);
        return this;
    }

    public <S> UseCaseMaidBuilder withSideEffects(Class<S> sideEffectType, SideEffectExecutor<S> sideEffectExecutor) {
        GenericType genericType = GenericType.genericType(sideEffectType);
        return this.withSideEffects(genericType, sideEffectExecutor);
    }

    public <S> UseCaseMaidBuilder withSideEffects(GenericType<S> sideEffectType, SideEffectExecutor<S> sideEffectExecutor) {
        SideEffectRegistration sideEffectRegistration = SideEffectRegistration.sideEffectRegistration(sideEffectType, sideEffectExecutor);
        this.sideEffectRegistrations.add(sideEffectRegistration);
        return this;
    }

    public UseCaseMaidBuilder withExecutionDriver(ExecutionDriver executionDriver) {
        NotNullValidator.validateNotNull((Object)executionDriver, (String)"executionDriver");
        this.executionDriver = executionDriver;
        return this;
    }

    public UseCaseMaidBuilder withDependencies(InjectorConfiguration module) {
        this.dependencies.add(module);
        return this;
    }

    public UseCaseMaidBuilder withInvocationScopedDependencies(InjectorConfiguration module) {
        this.invocationScopedDependencies.add(module);
        return this;
    }

    public UseCaseMaid build() {
        LinkedHashMap useCaseMethods = new LinkedHashMap();
        InjectMaidBuilder injectMaidBuilder = InjectMaid.anInjectMaid();
        MapMaidBuilder mapMaidBuilder = MapMaid.aMapMaid();
        this.dependencies.forEach(arg_0 -> ((InjectMaidBuilder)injectMaidBuilder).withConfiguration(arg_0));
        injectMaidBuilder.withScope(InvocationId.class, builder -> {
            this.invocationScopedDependencies.forEach(arg_0 -> ((InjectMaidBuilder)builder).withConfiguration(arg_0));
            this.useCases.forEach(type -> {
                ResolvedType resolvedType = type.toResolvedType();
                UseCaseMethod useCaseMethod = UseCaseMethod.useCaseMethodOf(resolvedType);
                useCaseMethods.put((GenericType<?>)type, useCaseMethod);
                UseCaseClassScanner.addMethod(useCaseMethod, mapMaidBuilder);
                builder.withType(type);
            });
        });
        LinkedHashMap<ResolvedType, SideEffectRegistration> sideEffectRegistrationMap = new LinkedHashMap<ResolvedType, SideEffectRegistration>();
        this.sideEffectRegistrations.forEach(sideEffectRegistration -> {
            GenericType<?> type = sideEffectRegistration.type();
            mapMaidBuilder.injecting(type);
            sideEffectRegistrationMap.put(type.toResolvedType(), (SideEffectRegistration)sideEffectRegistration);
        });
        SideEffectsSystem sideEffectsSystem = SideEffectsSystem.sideEffectsSystem(sideEffectRegistrationMap);
        MapMaid mapMaid = mapMaidBuilder.build();
        SerializerAndDeserializer serializerAndDeserializer = SerializerAndDeserializer.serializationAndDeserialization(mapMaid);
        InjectMaid injector = injectMaidBuilder.build();
        return UseCaseMaid.useCaseMaid(UseCases.useCases(useCaseMethods), (Injector)injector, serializerAndDeserializer, sideEffectsSystem, this.executionDriver);
    }

    @Generated
    private UseCaseMaidBuilder() {
    }
}

