/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.testmaid.internal.statemachine;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u0002H\u0001*\b\b\u0003\u0010\u0005*\u0002H\u0001*\b\b\u0004\u0010\u0006*\u0002H\u00032\u00020\u0002BN\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00040\b\u0012\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00020\bH\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00030\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00040\bH\u00c6\u0003J \u0010\u0018\u001a\u0019\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\rH\u00c6\u0003Jx\u0010\u0019\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u00002\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00040\b2\u001f\b\u0002\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\rH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\u001d\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010 J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R(\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006%"}, d2={"Lde/quantummaid/testmaid/internal/statemachine/Transition;", "StateSuperClass", "", "MessageSuperClass", "OriginState", "TargetState", "Message", "originStateClass", "Lkotlin/reflect/KClass;", "targetStateClass", "messageClass", "handler", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function2;)V", "getHandler", "()Lkotlin/jvm/functions/Function2;", "getMessageClass", "()Lkotlin/reflect/KClass;", "getOriginStateClass", "getTargetStateClass", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "handle", "currentState", "message", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "", "toString", "", "testmaid-core"})
public final class Transition<StateSuperClass, MessageSuperClass, OriginState extends StateSuperClass, TargetState extends StateSuperClass, Message extends MessageSuperClass> {
    @NotNull
    private final KClass<OriginState> originStateClass;
    @NotNull
    private final KClass<TargetState> targetStateClass;
    @NotNull
    private final KClass<Message> messageClass;
    @NotNull
    private final Function2<OriginState, Message, StateSuperClass> handler;

    @Nullable
    public final StateSuperClass handle(@NotNull StateSuperClass currentState, @NotNull MessageSuperClass message) {
        boolean messageMatches;
        Intrinsics.checkNotNullParameter(currentState, (String)"currentState");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean stateMatches = Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(currentState.getClass()), this.originStateClass);
        if (stateMatches && (messageMatches = Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(message.getClass()), this.messageClass))) {
            Object castedState = KClasses.cast(this.originStateClass, currentState);
            Object castedMessage = KClasses.cast(this.messageClass, message);
            Object newState = this.handler.invoke(castedState, castedMessage);
            return (StateSuperClass)newState;
        }
        return null;
    }

    @NotNull
    public final KClass<OriginState> getOriginStateClass() {
        return this.originStateClass;
    }

    @NotNull
    public final KClass<TargetState> getTargetStateClass() {
        return this.targetStateClass;
    }

    @NotNull
    public final KClass<Message> getMessageClass() {
        return this.messageClass;
    }

    @NotNull
    public final Function2<OriginState, Message, StateSuperClass> getHandler() {
        return this.handler;
    }

    public Transition(@NotNull KClass<OriginState> originStateClass, @NotNull KClass<TargetState> targetStateClass, @NotNull KClass<Message> messageClass, @NotNull Function2<? super OriginState, ? super Message, ? extends StateSuperClass> handler) {
        Intrinsics.checkNotNullParameter(originStateClass, (String)"originStateClass");
        Intrinsics.checkNotNullParameter(targetStateClass, (String)"targetStateClass");
        Intrinsics.checkNotNullParameter(messageClass, (String)"messageClass");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.originStateClass = originStateClass;
        this.targetStateClass = targetStateClass;
        this.messageClass = messageClass;
        this.handler = handler;
    }

    @NotNull
    public final KClass<OriginState> component1() {
        return this.originStateClass;
    }

    @NotNull
    public final KClass<TargetState> component2() {
        return this.targetStateClass;
    }

    @NotNull
    public final KClass<Message> component3() {
        return this.messageClass;
    }

    @NotNull
    public final Function2<OriginState, Message, StateSuperClass> component4() {
        return this.handler;
    }

    @NotNull
    public final Transition<StateSuperClass, MessageSuperClass, OriginState, TargetState, Message> copy(@NotNull KClass<OriginState> originStateClass, @NotNull KClass<TargetState> targetStateClass, @NotNull KClass<Message> messageClass, @NotNull Function2<? super OriginState, ? super Message, ? extends StateSuperClass> handler) {
        Intrinsics.checkNotNullParameter(originStateClass, (String)"originStateClass");
        Intrinsics.checkNotNullParameter(targetStateClass, (String)"targetStateClass");
        Intrinsics.checkNotNullParameter(messageClass, (String)"messageClass");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return new Transition<StateSuperClass, MessageSuperClass, OriginState, TargetState, Message>(originStateClass, targetStateClass, messageClass, handler);
    }

    public static /* synthetic */ Transition copy$default(Transition transition, KClass kClass, KClass kClass2, KClass kClass3, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            kClass = transition.originStateClass;
        }
        if ((n & 2) != 0) {
            kClass2 = transition.targetStateClass;
        }
        if ((n & 4) != 0) {
            kClass3 = transition.messageClass;
        }
        if ((n & 8) != 0) {
            function2 = transition.handler;
        }
        return transition.copy(kClass, kClass2, kClass3, function2);
    }

    @NotNull
    public String toString() {
        return "Transition(originStateClass=" + this.originStateClass + ", targetStateClass=" + this.targetStateClass + ", messageClass=" + this.messageClass + ", handler=" + this.handler + ")";
    }

    public int hashCode() {
        KClass<OriginState> kClass = this.originStateClass;
        KClass<TargetState> kClass2 = this.targetStateClass;
        KClass<Message> kClass3 = this.messageClass;
        Function2<OriginState, Message, StateSuperClass> function2 = this.handler;
        return (((kClass != null ? kClass.hashCode() : 0) * 31 + (kClass2 != null ? kClass2.hashCode() : 0)) * 31 + (kClass3 != null ? kClass3.hashCode() : 0)) * 31 + (function2 != null ? function2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Transition)) break block3;
                Transition transition = (Transition)object;
                if (!Intrinsics.areEqual(this.originStateClass, transition.originStateClass) || !Intrinsics.areEqual(this.targetStateClass, transition.targetStateClass) || !Intrinsics.areEqual(this.messageClass, transition.messageClass) || !Intrinsics.areEqual(this.handler, transition.handler)) break block3;
            }
            return true;
        }
        return false;
    }
}

