/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.RawClass;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.TypeVariableName;
import de.quantummaid.reflectmaid.UnsupportedJvmFeatureInTypeException;
import de.quantummaid.reflectmaid.resolvedtype.ArrayType;
import de.quantummaid.reflectmaid.resolvedtype.ClassType;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.resolvedtype.WildcardedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u00012\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002\u001a \u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"resolveClass", "Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;", "reflectMaid", "Lde/quantummaid/reflectmaid/ReflectMaid;", "clazz", "Ljava/lang/Class;", "resolveGenericArrayType", "Lde/quantummaid/reflectmaid/resolvedtype/ArrayType;", "genericArrayType", "Ljava/lang/reflect/GenericArrayType;", "context", "Lde/quantummaid/reflectmaid/resolvedtype/ClassType;", "resolveParameterizedType", "parameterizedType", "Ljava/lang/reflect/ParameterizedType;", "resolveType", "type", "Ljava/lang/reflect/Type;", "resolveTypeVariable", "typeVariable", "Ljava/lang/reflect/TypeVariable;", "fullType", "resolveWildcard", "Ljava/lang/reflect/WildcardType;", "reflectmaid-core"})
public final class TypeResolverKt {
    @NotNull
    public static final ResolvedType resolveType(@NotNull ReflectMaid reflectMaid, @NotNull Type type, @NotNull ClassType context) {
        ResolvedType resolvedType;
        Intrinsics.checkNotNullParameter((Object)reflectMaid, (String)"reflectMaid");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Type type2 = type;
        if (type2 instanceof Class) {
            resolvedType = TypeResolverKt.resolveClass(reflectMaid, (Class)type);
        } else if (type2 instanceof TypeVariable) {
            resolvedType = TypeResolverKt.resolveTypeVariable((TypeVariable)type, context);
        } else if (type2 instanceof ParameterizedType) {
            resolvedType = TypeResolverKt.resolveParameterizedType(reflectMaid, (ParameterizedType)type, context);
        } else if (type2 instanceof GenericArrayType) {
            resolvedType = TypeResolverKt.resolveGenericArrayType(reflectMaid, (GenericArrayType)type, context);
        } else if (type2 instanceof WildcardType) {
            resolvedType = TypeResolverKt.resolveWildcard(reflectMaid, (WildcardType)type, context);
        } else {
            throw (Throwable)new UnsupportedJvmFeatureInTypeException("Unknown 'Type' implementation by class '" + type.getClass() + "' on object '" + type + '\'');
        }
        return resolvedType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ResolvedType resolveClass(@NotNull ReflectMaid reflectMaid, @NotNull Class<?> clazz) {
        ResolvedType resolvedType;
        Intrinsics.checkNotNullParameter((Object)reflectMaid, (String)"reflectMaid");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        RawClass raw = reflectMaid.getRawClassCache$reflectmaid_core().rawClassFor$reflectmaid_core(clazz);
        if (raw.isArray()) {
            Class<?> clazz2 = raw.componentType();
            Intrinsics.checkNotNull(clazz2);
            ResolvedType componentType2 = reflectMaid.resolve(clazz2);
            resolvedType = new ArrayType(componentType2, reflectMaid);
        } else {
            TypeVariable<? extends Class<?>>[] typeVariableArray = raw.typeParameters();
            Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"raw.typeParameters()");
            TypeVariable<? extends Class<?>>[] componentType2 = typeVariableArray;
            boolean bl = false;
            TypeVariable<? extends Class<?>>[] typeVariableArray2 = componentType2;
            boolean bl2 = false;
            if (!(typeVariableArray2.length == 0)) {
                void $this$associateTo$iv$iv;
                ResolvedType any = reflectMaid.resolve(Object.class);
                TypeVariable<Class<?>>[] typeVariableArray3 = clazz.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(typeVariableArray3, (String)"clazz.typeParameters");
                TypeVariable<Class<?>>[] $this$associate$iv = typeVariableArray3;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
                TypeVariable<Class<?>>[] typeVariableArray4 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (void element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    void it = element$iv$iv;
                    boolean bl3 = false;
                    void v4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                    Pair pair = TuplesKt.to((Object)TypeVariableName.Companion.typeVariableName((TypeVariable<?>)v4), (Object)any);
                    boolean bl4 = false;
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map emptyTypeParameters = destination$iv$iv;
                resolvedType = ClassType.Companion.fromClassWithGenerics(reflectMaid, raw, emptyTypeParameters);
            } else {
                resolvedType = ClassType.Companion.fromClassWithoutGenerics(reflectMaid, raw);
            }
        }
        return resolvedType;
    }

    private static final ResolvedType resolveTypeVariable(TypeVariable<?> typeVariable, ClassType fullType) {
        TypeVariableName typeVariableName = TypeVariableName.Companion.typeVariableName(typeVariable);
        return fullType.resolveTypeVariable(typeVariableName);
    }

    /*
     * WARNING - void declaration
     */
    private static final ResolvedType resolveParameterizedType(ReflectMaid reflectMaid, ParameterizedType parameterizedType, ClassType context) {
        void $this$mapTo$iv$iv22;
        Type type = parameterizedType.getRawType();
        if (type == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        RawClass rawType = reflectMaid.getRawClassCache$reflectmaid_core().rawClassFor$reflectmaid_core((Class)type);
        TypeVariable<? extends Class<?>>[] typeVariableArray = rawType.typeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"rawType.typeParameters()");
        TypeVariable<? extends Class<?>>[] $this$map$iv = typeVariableArray;
        boolean $i$f$map = false;
        TypeVariable<? extends Class<?>>[] typeVariableArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var10_13 = $this$mapTo$iv$iv22;
        int n = ((void)var10_13).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_17 = item$iv$iv = var10_13[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            TypeVariableName typeVariableName = TypeVariableName.Companion.typeVariableName((TypeVariable<?>)v2);
            collection.add(typeVariableName);
        }
        List typeVariableNames = (List)destination$iv$iv;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Map typeParameters2 = new HashMap(actualTypeArguments.length);
        int $this$mapTo$iv$iv22 = 0;
        Intrinsics.checkNotNullExpressionValue((Object)actualTypeArguments, (String)"actualTypeArguments");
        int n2 = actualTypeArguments.length;
        while ($this$mapTo$iv$iv22 < n2) {
            void i;
            Type type2 = actualTypeArguments[i];
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"actualTypeArguments[i]");
            ResolvedType resolvedTypeArgument = reflectMaid.resolve(GenericType.Companion.fromReflectionType(type2, context));
            TypeVariableName name2 = (TypeVariableName)typeVariableNames.get((int)i);
            typeParameters2.put(name2, resolvedTypeArgument);
            ++i;
        }
        return ClassType.Companion.fromClassWithGenerics(reflectMaid, rawType, typeParameters2);
    }

    private static final ArrayType resolveGenericArrayType(ReflectMaid reflectMaid, GenericArrayType genericArrayType, ClassType context) {
        Type componentType2;
        Type type = componentType2 = genericArrayType.getGenericComponentType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"componentType");
        ResolvedType fullComponentType = TypeResolverKt.resolveType(reflectMaid, type, context);
        return new ArrayType(fullComponentType, reflectMaid);
    }

    private static final ResolvedType resolveWildcard(ReflectMaid reflectMaid, WildcardType type, ClassType context) {
        ResolvedType resolvedType;
        Type[] typeArray = type.getLowerBounds();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"type.lowerBounds");
        Type[] typeArray2 = typeArray;
        boolean bl = false;
        if (typeArray2.length == 0 && type.getUpperBounds().length == 1) {
            Type upperBound;
            Type type2 = upperBound = type.getUpperBounds()[0];
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"upperBound");
            resolvedType = TypeResolverKt.resolveType(reflectMaid, type2, context);
        } else {
            resolvedType = new WildcardedType();
        }
        return resolvedType;
    }
}

