/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.TypeVariableName;
import de.quantummaid.reflectmaid.UnsupportedJvmFeatureInTypeException;
import de.quantummaid.reflectmaid.resolvedtype.ArrayType;
import de.quantummaid.reflectmaid.resolvedtype.ClassType;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.resolvedtype.WildcardedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u00012\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"resolveClass", "Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;", "reflectMaid", "Lde/quantummaid/reflectmaid/ReflectMaid;", "clazz", "Ljava/lang/Class;", "fullType", "Lde/quantummaid/reflectmaid/resolvedtype/ClassType;", "resolveGenericArrayType", "Lde/quantummaid/reflectmaid/resolvedtype/ArrayType;", "genericArrayType", "Ljava/lang/reflect/GenericArrayType;", "context", "resolveParameterizedType", "parameterizedType", "Ljava/lang/reflect/ParameterizedType;", "resolveType", "type", "Ljava/lang/reflect/Type;", "resolveTypeVariable", "typeVariable", "Ljava/lang/reflect/TypeVariable;", "resolveWildcard", "Ljava/lang/reflect/WildcardType;", "reflectmaid-core"})
public final class TypeResolverKt {
    @NotNull
    public static final ResolvedType resolveType(@NotNull ReflectMaid reflectMaid, @NotNull Type type, @NotNull ClassType context) {
        ResolvedType resolvedType;
        Intrinsics.checkNotNullParameter((Object)reflectMaid, (String)"reflectMaid");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Type type2 = type;
        if (type2 instanceof Class) {
            resolvedType = TypeResolverKt.resolveClass(reflectMaid, (Class)type, context);
        } else if (type2 instanceof TypeVariable) {
            resolvedType = TypeResolverKt.resolveTypeVariable((TypeVariable)type, context);
        } else if (type2 instanceof ParameterizedType) {
            resolvedType = TypeResolverKt.resolveParameterizedType(reflectMaid, (ParameterizedType)type, context);
        } else if (type2 instanceof GenericArrayType) {
            resolvedType = TypeResolverKt.resolveGenericArrayType(reflectMaid, (GenericArrayType)type, context);
        } else if (type2 instanceof WildcardType) {
            resolvedType = TypeResolverKt.resolveWildcard(reflectMaid, (WildcardType)type, context);
        } else {
            throw (Throwable)new UnsupportedJvmFeatureInTypeException("Unknown 'Type' implementation by class '" + type.getClass() + "' on object '" + type + '\'');
        }
        return resolvedType;
    }

    private static final ResolvedType resolveClass(ReflectMaid reflectMaid, Class<?> clazz, ClassType fullType) {
        ResolvedType resolvedType;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"clazz.componentType");
            ResolvedType componentType = TypeResolverKt.resolveType(reflectMaid, clazz2, fullType);
            resolvedType = ArrayType.Companion.arrayType(componentType);
        } else {
            resolvedType = ClassType.Companion.fromClassWithoutGenerics(reflectMaid, clazz);
        }
        return resolvedType;
    }

    private static final ResolvedType resolveTypeVariable(TypeVariable<?> typeVariable, ClassType fullType) {
        TypeVariableName typeVariableName = TypeVariableName.Companion.typeVariableName(typeVariable);
        return fullType.resolveTypeVariable(typeVariableName);
    }

    /*
     * WARNING - void declaration
     */
    private static final ResolvedType resolveParameterizedType(ReflectMaid reflectMaid, ParameterizedType parameterizedType, ClassType context) {
        Type type = parameterizedType.getRawType();
        if (type == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        Class rawType = (Class)type;
        List<TypeVariableName> typeVariableNames = TypeVariableName.Companion.typeVariableNamesOf(rawType);
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Map typeParameters = new HashMap(actualTypeArguments.length);
        int n = 0;
        Intrinsics.checkNotNullExpressionValue((Object)actualTypeArguments, (String)"actualTypeArguments");
        int n2 = actualTypeArguments.length;
        while (n < n2) {
            void i;
            Type type2 = actualTypeArguments[i];
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"actualTypeArguments[i]");
            ResolvedType resolvedTypeArgument = reflectMaid.resolve(GenericType.Companion.fromReflectionType(type2, context));
            TypeVariableName name = typeVariableNames.get((int)i);
            typeParameters.put(name, resolvedTypeArgument);
            ++i;
        }
        return ClassType.Companion.fromClassWithGenerics(reflectMaid, rawType, typeParameters);
    }

    private static final ArrayType resolveGenericArrayType(ReflectMaid reflectMaid, GenericArrayType genericArrayType, ClassType context) {
        Type componentType;
        Type type = componentType = genericArrayType.getGenericComponentType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"componentType");
        ResolvedType fullComponentType = TypeResolverKt.resolveType(reflectMaid, type, context);
        return ArrayType.Companion.arrayType(fullComponentType);
    }

    private static final ResolvedType resolveWildcard(ReflectMaid reflectMaid, WildcardType type, ClassType context) {
        ResolvedType resolvedType;
        Type[] typeArray = type.getLowerBounds();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"type.lowerBounds");
        Type[] typeArray2 = typeArray;
        boolean bl = false;
        if (typeArray2.length == 0 && type.getUpperBounds().length == 1) {
            Type upperBound;
            Type type2 = upperBound = type.getUpperBounds()[0];
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"upperBound");
            resolvedType = TypeResolverKt.resolveType(reflectMaid, type2, context);
        } else {
            resolvedType = WildcardedType.Companion.wildcardType();
        }
        return resolvedType;
    }
}

