/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.testsupport.givenwhenthen;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.scaninformation.Classification;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import de.quantummaid.mapmaid.testsupport.givenwhenthen.ThenData;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;

public final class Then {
    private final ThenData thenData;

    public static Then then(ThenData thenData) {
        return new Then(thenData);
    }

    public Then theDeserializedObjectIs(Object expected) {
        MatcherAssert.assertThat((Object)this.thenData.getDeserializationResult(), (Matcher)CoreMatchers.is((Object)expected));
        return this;
    }

    public <T> Then theDeserialiedObjectHas(Class<T> type, Predicate<T> predicate) {
        Object deserializationResult = this.thenData.getDeserializationResult();
        MatcherAssert.assertThat((Object)deserializationResult, (Matcher)CoreMatchers.instanceOf(type));
        MatcherAssert.assertThat((Object)predicate.test(deserializationResult), (Matcher)CoreMatchers.is((Object)true));
        return this;
    }

    public Then anExceptionIsThrownWithAMessageContaining(String message) {
        MatcherAssert.assertThat((Object)this.thenData.getException(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)this.thenData.getException().getMessage(), (Matcher)StringContains.containsString((String)message));
        return this;
    }

    public Then noExceptionHasBeenThrown() {
        if (Objects.nonNull(this.thenData.getException())) {
            this.thenData.getException().printStackTrace();
        }
        MatcherAssert.assertThat((Object)this.thenData.getException(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        return this;
    }

    public Then anAggregatedExceptionHasBeenThrownWithNumberOfErrors(int numberOfErrors) {
        MatcherAssert.assertThat((Object)this.thenData.getException(), (Matcher)CoreMatchers.instanceOf(AggregatedValidationException.class));
        AggregatedValidationException aggregatedValidationException = (AggregatedValidationException)this.thenData.getException();
        MatcherAssert.assertThat((Object)aggregatedValidationException.getValidationErrors(), (Matcher)Matchers.hasSize((int)numberOfErrors));
        return this;
    }

    public Then theDefinitionsContainExactlyTheCustomPrimitives(Class<?> ... types) {
        DebugInformation debugInformation = this.thenData.getDebugInformation();
        List actualTypes = Arrays.stream(types).filter(classType -> debugInformation.optionalScanInformationFor(classType).map(Then::isCustomPrimitive).orElseThrow()).collect(Collectors.toList());
        MatcherAssert.assertThat(actualTypes, (Matcher)Matchers.containsInAnyOrder((Object[])types));
        MatcherAssert.assertThat((Object)Then.countCustomPrimitives(debugInformation), (Matcher)CoreMatchers.is((Object)types.length));
        return this;
    }

    public Then theDefinitionsContainExactlyTheSerializedObjects(Class<?> ... types) {
        DebugInformation debugInformation = this.thenData.getDebugInformation();
        List actualTypes = Arrays.stream(types).filter(classType -> debugInformation.optionalScanInformationFor(classType).map(Then::isSerializedObject).orElseThrow()).collect(Collectors.toList());
        MatcherAssert.assertThat(actualTypes, (Matcher)Matchers.containsInAnyOrder((Object[])types));
        MatcherAssert.assertThat((Object)Then.countSerializedObjects(debugInformation), (Matcher)CoreMatchers.is((Object)types.length));
        return this;
    }

    public Then theSerializationResultWas(String serialized) {
        MatcherAssert.assertThat((Object)this.thenData.getSerializationResult(), (Matcher)CoreMatchers.is((Object)serialized));
        return this;
    }

    private static int countCustomPrimitives(DebugInformation debugInformation) {
        return (int)debugInformation.allScanInformations().stream().filter(Then::isCustomPrimitive).count();
    }

    private static int countSerializedObjects(DebugInformation debugInformation) {
        return (int)debugInformation.allScanInformations().stream().filter(Then::isSerializedObject).count();
    }

    private static boolean isCustomPrimitive(ScanInformation scanInformation) {
        return scanInformation.classification().equals((Object)Classification.CUSTOM_PRIMITIVE);
    }

    private static boolean isSerializedObject(ScanInformation scanInformation) {
        return scanInformation.classification().equals((Object)Classification.SERIALIZED_OBJECT);
    }

    Then(ThenData thenData) {
        this.thenData = thenData;
    }
}

