/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.testsupport.givenwhenthen;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.Gson;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import java.io.IOException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class Unmarshallers {
    private Unmarshallers() {
    }

    public static Unmarshaller jsonUnmarshaller() {
        Gson gson = new Gson();
        return (arg_0, arg_1) -> ((Gson)gson).fromJson(arg_0, arg_1);
    }

    public static Unmarshaller xmlUnmarshaller() {
        final XmlMapper xmlMapper = new XmlMapper();
        return new Unmarshaller(){

            public <T> T unmarshal(String input, Class<T> type) {
                try {
                    return (T)xmlMapper.readValue(input, type);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Unmarshaller yamlUnmarshaller() {
        DumperOptions options = new DumperOptions();
        final Yaml yaml = new Yaml(options);
        return new Unmarshaller(){

            public <T> T unmarshal(String input, Class<T> type) {
                return (T)yaml.load(input);
            }
        };
    }
}

