/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.timing;

import de.quantummaid.injectmaid.timing.InstanceAndTimedDependencies;
import de.quantummaid.injectmaid.timing.InstantiationTime;
import de.quantummaid.injectmaid.timing.TimedInstantiator;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.function.Function;
import lombok.Generated;

public final class TimedInstantiation<T> {
    private final T object;
    private final InstantiationTime instantiationTime;

    public static <T> TimedInstantiation<T> timeInstantiation(TypeIdentifier type, TimedInstantiator<T> supplier) {
        InstantiationTime instantiationTime = InstantiationTime.instantiationTime(type, 0L);
        return TimedInstantiation.timeInstantiation(supplier, instantiationTime);
    }

    private static <T> TimedInstantiation<T> timeInstantiation(TimedInstantiator<T> supplier, InstantiationTime baseValue) {
        long startTime = System.currentTimeMillis();
        InstanceAndTimedDependencies<T> instanceAndTimedDependencies = supplier.instantiate();
        long endTime = System.currentTimeMillis();
        InstantiationTime instantiationTime = baseValue.addTime(endTime - startTime);
        instanceAndTimedDependencies.dependencies().forEach(instantiationTime::reportDependency);
        return new TimedInstantiation<T>(instanceAndTimedDependencies.instance(), instantiationTime);
    }

    public <X> TimedInstantiation<X> modify(Function<T, X> modifier) {
        return TimedInstantiation.timeInstantiation(() -> InstanceAndTimedDependencies.instanceWithNoDependencies(modifier.apply(this.object)), this.instantiationTime);
    }

    public T instance() {
        return this.object;
    }

    public InstantiationTime instantiationTime() {
        return this.instantiationTime;
    }

    @Generated
    private TimedInstantiation(T object, InstantiationTime instantiationTime) {
        this.object = object;
        this.instantiationTime = instantiationTime;
    }
}

