/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.timing;

import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.timing.InstantiationTime;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InstantiationTimes {
    private final ReflectMaid reflectMaid;
    private final Map<TypeIdentifier, InstantiationTime> instantiationTimes = new HashMap<TypeIdentifier, InstantiationTime>();

    public static InstantiationTimes instantiationTimes(ReflectMaid reflectMaid) {
        return new InstantiationTimes(reflectMaid);
    }

    public void addInitializationTime(TypeIdentifier type, InstantiationTime time) {
        this.instantiationTimes.put(type, time);
    }

    public InstantiationTime initializationTimeFor(Class<?> type) {
        GenericType genericType2 = GenericType.genericType(type);
        return this.initializationTimeFor(genericType2);
    }

    public InstantiationTime initializationTimeFor(GenericType<?> genericType2) {
        ResolvedType resolvedType = this.reflectMaid.resolve(genericType2);
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedType);
        if (!this.instantiationTimes.containsKey(typeIdentifier)) {
            throw InjectMaidException.injectMaidException(String.format("no instantiation time available for %s", resolvedType.description()));
        }
        return this.instantiationTimes.get(typeIdentifier);
    }

    public List<InstantiationTime> allInstantiationTimes() {
        return new ArrayList<InstantiationTime>(this.instantiationTimes.values());
    }

    public String render() {
        return this.instantiationTimes.values().stream().map(InstantiationTime::render).collect(Collectors.joining("\n"));
    }

    @Generated
    private InstantiationTimes(ReflectMaid reflectMaid) {
        this.reflectMaid = reflectMaid;
    }
}

