/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api.interception.timing;

import de.quantummaid.injectmaid.api.ReusePolicy;
import de.quantummaid.injectmaid.api.interception.Interceptor;
import de.quantummaid.injectmaid.api.interception.timing.EnforcedMaxInstantiationTimeExceededException;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;

public final class TimingInterceptor
implements Interceptor {
    private final Duration maxDuration;
    private Instant before;

    public static TimingInterceptor timingInterceptor(Duration maxDuration) {
        return new TimingInterceptor(maxDuration);
    }

    @Override
    public Optional<?> interceptBeforeInstantiation(TypeIdentifier type, TypeIdentifier rootType) {
        this.before = Instant.now();
        return Optional.empty();
    }

    @Override
    public Object interceptAfterInstantiation(TypeIdentifier type, TypeIdentifier rootType, ReusePolicy reusePolicy, Object instance) {
        Instant after = Instant.now();
        Duration duration = Duration.between(this.before, after);
        if (duration.compareTo(this.maxDuration) > 0) {
            throw EnforcedMaxInstantiationTimeExceededException.enforcedMaxInstantiationTimeExceededException(type, rootType, instance, this.maxDuration, duration, reusePolicy);
        }
        return instance;
    }

    @Generated
    private TimingInterceptor(Duration maxDuration) {
        this.maxDuration = maxDuration;
    }
}

