/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api.interception.overwrite;

import de.quantummaid.injectmaid.api.Injector;
import de.quantummaid.injectmaid.api.ReusePolicy;
import de.quantummaid.injectmaid.api.interception.Interceptor;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.Optional;
import lombok.Generated;

public final class OverwritingInterceptor
implements Interceptor {
    private final Injector injector;

    public static OverwritingInterceptor overwritingInterceptor(Injector injector) {
        return new OverwritingInterceptor(injector);
    }

    @Override
    public Optional<?> interceptBeforeInstantiation(TypeIdentifier type, TypeIdentifier rootType) {
        if (!this.injector.canInstantiate(type)) {
            return Optional.empty();
        }
        Object instance = this.injector.getInstance(type);
        return Optional.of(instance);
    }

    @Override
    public Object interceptAfterInstantiation(TypeIdentifier type, TypeIdentifier rootType, ReusePolicy reusePolicy, Object instance) {
        return instance;
    }

    @Override
    public Interceptor enterScope(TypeIdentifier scopeType, Object scopeObject) {
        Injector scopedInjector = this.injector.enterScope(scopeType, scopeObject);
        return new OverwritingInterceptor(scopedInjector);
    }

    @Generated
    public String toString() {
        return "OverwritingInterceptor(injector=" + this.injector + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OverwritingInterceptor)) {
            return false;
        }
        OverwritingInterceptor other = (OverwritingInterceptor)o;
        Injector this$injector = this.injector;
        Injector other$injector = other.injector;
        return !(this$injector == null ? other$injector != null : !this$injector.equals(other$injector));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Injector $injector = this.injector;
        result = result * 59 + ($injector == null ? 43 : $injector.hashCode());
        return result;
    }

    @Generated
    private OverwritingInterceptor(Injector injector) {
        this.injector = injector;
    }
}

