/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api.interception;

import de.quantummaid.injectmaid.api.interception.Interceptor;
import de.quantummaid.injectmaid.api.interception.InterceptorFactory;
import de.quantummaid.injectmaid.api.interception.Interceptors;
import de.quantummaid.injectmaid.api.interception.SingletonInterceptorFactory;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InterceptorFactories {
    private final List<InterceptorFactory> factories;

    public static InterceptorFactories interceptorFactories(List<InterceptorFactory> factories) {
        return new InterceptorFactories(factories);
    }

    public void addFactory(InterceptorFactory factory) {
        this.factories.add(factory);
    }

    public void addInterceptor(Interceptor interceptor) {
        SingletonInterceptorFactory factory = SingletonInterceptorFactory.singletonInterceptorFactory(interceptor);
        this.addFactory(factory);
    }

    public Interceptors interceptors() {
        List<Interceptor> interceptors = this.factories.stream().map(InterceptorFactory::createInterceptor).collect(Collectors.toList());
        return Interceptors.interceptors(interceptors);
    }

    public InterceptorFactories enterScope(TypeIdentifier scopeType, Object scopeObject) {
        List<InterceptorFactory> scopedFactories = this.factories.stream().map(factory -> factory.enterScope(scopeType, scopeObject)).collect(Collectors.toList());
        return new InterceptorFactories(scopedFactories);
    }

    @Generated
    private InterceptorFactories(List<InterceptorFactory> factories) {
        this.factories = factories;
    }
}

