/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.timing;

import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import lombok.Generated;

public final class InstantiationTime {
    private static final String INDENT = "\t";
    private final TypeIdentifier type;
    private final long timeInMilliseconds;
    private final List<InstantiationTime> dependencies;

    public static InstantiationTime instantiationTime(TypeIdentifier type, long timeInMilliseconds) {
        return new InstantiationTime(type, timeInMilliseconds, new ArrayList<InstantiationTime>());
    }

    public InstantiationTime addTime(long time) {
        return new InstantiationTime(this.type, this.timeInMilliseconds + time, this.dependencies);
    }

    public void reportDependency(InstantiationTime instantiationTime) {
        this.dependencies.add(instantiationTime);
    }

    public long timeInMilliseconds() {
        return this.timeInMilliseconds;
    }

    public TypeIdentifier type() {
        return this.type;
    }

    public List<InstantiationTime> dependencies() {
        return this.dependencies;
    }

    public String render() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        this.render("", stringJoiner);
        return stringJoiner.toString();
    }

    private void render(String indentation, StringJoiner stringJoiner) {
        String line = String.format("%s%dms %s", indentation, this.timeInMilliseconds, this.type.simpleDescription());
        stringJoiner.add(line);
        String childIndentation = indentation + INDENT;
        this.dependencies.forEach(dependency -> dependency.render(childIndentation, stringJoiner));
    }

    @Generated
    private InstantiationTime(TypeIdentifier type, long timeInMilliseconds, List<InstantiationTime> dependencies) {
        this.type = type;
        this.timeInMilliseconds = timeInMilliseconds;
        this.dependencies = dependencies;
    }
}

