/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.statemachine;

import de.quantummaid.injectmaid.api.ReusePolicy;
import de.quantummaid.injectmaid.detection.Detectors;
import de.quantummaid.injectmaid.detection.SingletonSwitch;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.statemachine.FactoryMapper;
import de.quantummaid.injectmaid.statemachine.InjectMaidTypeScannerResult;
import de.quantummaid.injectmaid.statemachine.ReusePolicyMapper;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import de.quantummaid.reflectmaid.typescanner.requirements.DetectionRequirements;
import de.quantummaid.reflectmaid.typescanner.scopes.Scope;
import de.quantummaid.reflectmaid.typescanner.states.DetectionResult;
import de.quantummaid.reflectmaid.typescanner.states.Detector;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class InjectMaidDetector
implements Detector<InjectMaidTypeScannerResult> {
    private final FactoryMapper factoryMapper;
    private final ReusePolicyMapper reusePolicyMapper;

    public static InjectMaidDetector injectMaidDetector(FactoryMapper factoryMapper, ReusePolicyMapper reusePolicyMapper) {
        return new InjectMaidDetector(factoryMapper, reusePolicyMapper);
    }

    @NotNull
    public DetectionResult<InjectMaidTypeScannerResult> detect(@NotNull TypeIdentifier type, @NotNull Scope scope, @NotNull DetectionRequirements detectionRequirements) {
        ReusePolicy oldReusePolicy = this.reusePolicyMapper.reusePolicyFor(type, scope);
        SingletonSwitch singletonSwitch = SingletonSwitch.singletonSwitch(oldReusePolicy);
        ResolvedType factory = this.factoryMapper.factoryFor(type).orElse(type.realType());
        DetectionResult<Instantiator> result = Detectors.detect(type, factory, singletonSwitch);
        return result.mapWithNull(instantiator -> {
            ReusePolicy reusePolicy = singletonSwitch.getReusePolicy();
            return InjectMaidTypeScannerResult.result(type, scope, instantiator, reusePolicy);
        });
    }

    @Generated
    private InjectMaidDetector(FactoryMapper factoryMapper, ReusePolicyMapper reusePolicyMapper) {
        this.factoryMapper = factoryMapper;
        this.reusePolicyMapper = reusePolicyMapper;
    }
}

