/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.lifecyclemanagement;

import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.lifecyclemanagement.ExceptionDuringClose;
import de.quantummaid.injectmaid.lifecyclemanagement.LifecycleManager;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.Closeable;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.Closers;
import de.quantummaid.reflectmaid.typescanner.scopes.Scope;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class RealLifecycleManager
implements LifecycleManager {
    private final Closers closers;
    private final List<Closeable> closeables = new ArrayList<Closeable>();
    private final Scope scope;
    private final LifecycleManager parent;

    public static LifecycleManager realLifecycleManager(Closers closers, Scope scope) {
        return new RealLifecycleManager(closers, scope, null);
    }

    @Override
    public LifecycleManager newInstance(Scope scope) {
        return new RealLifecycleManager(this.closers, scope, this);
    }

    @Override
    public void registerInstance(Object instance, Scope scope) {
        if (!this.scope.equals((Object)scope)) {
            if (this.parent == null) {
                throw InjectMaidException.injectMaidException("unable to register autoclosable in scope '" + scope.render() + "' - this should never happen");
            }
            this.parent.registerInstance(instance, scope);
        } else {
            this.closers.createCloseable(instance).ifPresent(this.closeables::add);
        }
    }

    @Override
    public void closeAll(List<ExceptionDuringClose> exceptions) {
        this.closeables.forEach(autoCloseable -> autoCloseable.close().ifPresent(exceptions::add));
    }

    @Override
    public LifecycleManager child() {
        return this;
    }

    @Generated
    private RealLifecycleManager(Closers closers, Scope scope, LifecycleManager parent) {
        this.closers = closers;
        this.scope = scope;
        this.parent = parent;
    }
}

