/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.circledetector;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import de.quantummaid.reflectmaid.typescanner.scopes.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class CircularDependencyDetector {
    private CircularDependencyDetector() {
    }

    public static void validateNoCircularDependencies(Definitions definitions) {
        definitions.allScopes().forEach(scope -> CircularDependencyDetector.validateNoCircularDependenciesInScope(definitions, scope));
    }

    private static void validateNoCircularDependenciesInScope(Definitions definitions, Scope scope) {
        List<Definition> definitionList = definitions.definitionsOnScope(scope);
        definitionList.forEach(definition -> {
            ArrayList<Definition> alreadyVisited = new ArrayList<Definition>();
            CircularDependencyDetector.detectCircle(definition, alreadyVisited, definitions, scope);
        });
    }

    private static void detectCircle(Definition definition, List<Definition> alreadyVisited, Definitions definitions, Scope scope) {
        if (alreadyVisited.contains(definition)) {
            alreadyVisited.add(definition);
            String circle = alreadyVisited.stream().map(Definition::type).map(TypeIdentifier::simpleDescription).collect(Collectors.joining(" -> "));
            throw InjectMaidException.injectMaidException(String.format("Illegal circular dependency in scope '%s' detected: %s", scope.render(), circle));
        }
        alreadyVisited.add(definition);
        Instantiator instantiator = definition.instantiator();
        for (TypeIdentifier dependencyType : instantiator.dependencies()) {
            Definition dependency = definitions.definitionFor(dependencyType, scope);
            CircularDependencyDetector.detectCircle(dependency, new ArrayList<Definition>(alreadyVisited), definitions, scope);
        }
    }
}

