/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api.interception;

import de.quantummaid.injectmaid.api.interception.Interceptor;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Interceptors {
    private final List<Interceptor> interceptors;

    public static Interceptors interceptors() {
        return new Interceptors(new ArrayList<Interceptor>());
    }

    public Optional<?> interceptBefore(TypeIdentifier type) {
        return this.interceptors.stream().map(interceptor -> interceptor.interceptBeforeInstantiation(type)).flatMap(Optional::stream).findFirst();
    }

    public Object interceptAfter(TypeIdentifier type, Object object) {
        Object current = object;
        for (Interceptor interceptor : this.interceptors) {
            current = interceptor.interceptAfterInstantiation(type, current);
        }
        return current;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public Interceptors enterScope(TypeIdentifier scopeType, Object scopeObject) {
        List<Interceptor> scopedInterceptors = this.interceptors.stream().map(interceptor -> interceptor.enterScope(scopeType, scopeObject)).collect(Collectors.toList());
        return new Interceptors(scopedInterceptors);
    }

    @Generated
    public String toString() {
        return "Interceptors(interceptors=" + this.interceptors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interceptors)) {
            return false;
        }
        Interceptors other = (Interceptors)o;
        List<Interceptor> this$interceptors = this.interceptors;
        List<Interceptor> other$interceptors = other.interceptors;
        return !(this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Interceptor> $interceptors = this.interceptors;
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        return result;
    }

    @Generated
    private Interceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

