/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api;

import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.api.InjectorConfiguration;
import de.quantummaid.injectmaid.api.interception.SimpleInterceptor;
import de.quantummaid.injectmaid.timing.TimedInstantiation;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import java.util.Optional;

public interface Injector
extends AutoCloseable {
    default public <T> T getInstance(Class<T> type) {
        GenericType genericType2 = GenericType.genericType(type);
        return this.getInstance(genericType2);
    }

    default public <T> T getInstance(GenericType<T> type) {
        TimedInstantiation<T> instanceWithInitializationTime = this.getInstanceWithInitializationTime(type);
        return instanceWithInitializationTime.instance();
    }

    default public <T> T getInstance(ResolvedType type) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)type);
        return this.getInstance(typeIdentifier);
    }

    public <T> T getInstance(TypeIdentifier var1);

    default public <T> TimedInstantiation<T> getInstanceWithInitializationTime(Class<T> type) {
        GenericType genericType2 = GenericType.genericType(type);
        return this.getInstanceWithInitializationTime(genericType2);
    }

    public <T> TimedInstantiation<T> getInstanceWithInitializationTime(GenericType<T> var1);

    public void initializeAllSingletons();

    default public Injector enterScope(Object scopeObject) {
        Class<?> scopeType = scopeObject.getClass();
        return this.enterScope(scopeType, scopeObject);
    }

    default public <T> Injector enterScope(Class<T> scopeType, T scopeObject) {
        GenericType genericType2 = GenericType.genericType(scopeType);
        return this.enterScope(genericType2, scopeObject);
    }

    public <T> Injector enterScope(GenericType<T> var1, T var2);

    default public Injector enterScope(ResolvedType scopeType, Object scopeObject) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)scopeType);
        return this.enterScope(typeIdentifier, scopeObject);
    }

    public Injector enterScope(TypeIdentifier var1, Object var2);

    default public Optional<Injector> enterScopeIfExists(Object scopeObject) {
        Class<?> scopeType = scopeObject.getClass();
        return this.enterScopeIfExists(scopeType, scopeObject);
    }

    default public <T> Optional<Injector> enterScopeIfExists(Class<T> scopeType, T scopeObject) {
        GenericType genericType2 = GenericType.genericType(scopeType);
        return this.enterScopeIfExists(genericType2, scopeObject);
    }

    public <T> Optional<Injector> enterScopeIfExists(GenericType<T> var1, T var2);

    public Optional<Injector> enterScopeIfExists(ResolvedType var1, Object var2);

    public void addInterceptor(SimpleInterceptor var1);

    default public void overwriteWith(InjectorConfiguration injectorConfiguration) {
        InjectMaidBuilder builder = InjectMaid.anInjectMaid(this.reflectMaid());
        injectorConfiguration.apply(builder);
        InjectMaid injectMaid = builder.build();
        this.overwriteWith(injectMaid);
    }

    public void overwriteWith(Injector var1);

    default public boolean canInstantiate(Class<?> type) {
        GenericType genericType2 = GenericType.genericType(type);
        return this.canInstantiate(genericType2);
    }

    public boolean canInstantiate(GenericType<?> var1);

    default public boolean canInstantiate(ResolvedType type) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)type);
        return this.canInstantiate(typeIdentifier);
    }

    public boolean canInstantiate(TypeIdentifier var1);

    @Override
    public void close();

    public ReflectMaid reflectMaid();
}

