/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.Requirements;
import de.quantummaid.injectmaid.Scopes;
import de.quantummaid.injectmaid.api.AbstractInjectorBuilder;
import de.quantummaid.injectmaid.api.InjectorConfiguration;
import de.quantummaid.injectmaid.api.ReusePolicy;
import de.quantummaid.injectmaid.api.SingletonType;
import de.quantummaid.injectmaid.api.customtype.CustomTypeInstantiator;
import de.quantummaid.injectmaid.api.customtype.api.CustomType;
import de.quantummaid.injectmaid.api.customtype.api.CustomTypeData;
import de.quantummaid.injectmaid.instantiator.BindInstantiator;
import de.quantummaid.injectmaid.instantiator.CustomInstantiatorFactory;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.instantiator.ScopeInstantiator;
import de.quantummaid.injectmaid.lifecyclemanagement.LifecycleManager;
import de.quantummaid.injectmaid.lifecyclemanagement.NoOpLifecycleManager;
import de.quantummaid.injectmaid.lifecyclemanagement.RealLifecycleManager;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.CloseFunction;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.Closer;
import de.quantummaid.injectmaid.lifecyclemanagement.closer.Closers;
import de.quantummaid.injectmaid.statemachine.FactoryMapper;
import de.quantummaid.injectmaid.statemachine.InjectMaidDetector;
import de.quantummaid.injectmaid.statemachine.InjectMaidOnCollectionError;
import de.quantummaid.injectmaid.statemachine.InjectMaidResolver;
import de.quantummaid.injectmaid.statemachine.InjectMaidTypeScannerResult;
import de.quantummaid.injectmaid.statemachine.ReusePolicyMapper;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.OnCollectionError;
import de.quantummaid.reflectmaid.typescanner.Processor;
import de.quantummaid.reflectmaid.typescanner.Reason;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import de.quantummaid.reflectmaid.typescanner.factories.StateFactories;
import de.quantummaid.reflectmaid.typescanner.factories.StateFactory;
import de.quantummaid.reflectmaid.typescanner.factories.UndetectedFactory;
import de.quantummaid.reflectmaid.typescanner.requirements.RequirementName;
import de.quantummaid.reflectmaid.typescanner.scopes.Scope;
import de.quantummaid.reflectmaid.typescanner.signals.AddReasonSignal;
import de.quantummaid.reflectmaid.typescanner.signals.Signal;
import de.quantummaid.reflectmaid.typescanner.states.Detector;
import de.quantummaid.reflectmaid.typescanner.states.RequirementsDescriber;
import de.quantummaid.reflectmaid.typescanner.states.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InjectMaidBuilder
implements AbstractInjectorBuilder<InjectMaidBuilder> {
    private static final ReusePolicy DEFAULT_REUSE_POLICY = ReusePolicy.PROTOTYPE;
    private final ReflectMaid reflectMaid;
    private boolean registerShutdownHook = false;
    private final List<Signal<InjectMaidTypeScannerResult>> signals;
    private final Map<Scope, List<StateFactory<InjectMaidTypeScannerResult>>> stateFactoryMap;
    private final FactoryMapper factoryMapper;
    private final ReusePolicyMapper reusePolicyMapper;
    private final Scope scope;
    private final Scopes scopes;
    private SingletonType defaultSingletonType = SingletonType.LAZY;
    private boolean lifecycleManagement = false;
    private final List<Closer> closers = new ArrayList<Closer>();

    static InjectMaidBuilder injectMaidBuilder(ReflectMaid reflectMaid) {
        Scope scope = Scope.rootScope();
        Scopes scopes = Scopes.scopes();
        scopes.add(scope);
        LinkedHashMap<Scope, List<StateFactory<InjectMaidTypeScannerResult>>> stateFactoryMap = new LinkedHashMap<Scope, List<StateFactory<InjectMaidTypeScannerResult>>>();
        ArrayList<Signal<InjectMaidTypeScannerResult>> signals = new ArrayList<Signal<InjectMaidTypeScannerResult>>();
        FactoryMapper factoryMapper = FactoryMapper.factoryMapper();
        ReusePolicyMapper reusePolicyMapper = ReusePolicyMapper.reusePolicyMapper(DEFAULT_REUSE_POLICY);
        return new InjectMaidBuilder(reflectMaid, signals, stateFactoryMap, factoryMapper, reusePolicyMapper, scope, scopes);
    }

    @Override
    public InjectMaidBuilder withConfiguration(InjectorConfiguration configuration) {
        configuration.apply(this);
        return this;
    }

    @Override
    public InjectMaidBuilder withScope(GenericType<?> scopeType, InjectorConfiguration configuration) {
        ResolvedType resolvedScopeType = this.reflectMaid.resolve(scopeType);
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedScopeType);
        return this.withScope(typeIdentifier, configuration);
    }

    public InjectMaidBuilder withScope(TypeIdentifier scopeType, InjectorConfiguration configuration) {
        Scope subScope = this.scope.childScope(scopeType);
        if (!this.scopes.contains(subScope)) {
            this.scopes.validateElementNotUsedSomewhereElse(scopeType);
        }
        InjectMaidBuilder scopedBuilder = new InjectMaidBuilder(this.reflectMaid, this.signals, this.stateFactoryMap, this.factoryMapper, this.reusePolicyMapper, subScope, this.scopes);
        scopedBuilder.lifecycleManagement = this.lifecycleManagement;
        if (!this.scopes.contains(subScope)) {
            scopedBuilder.withInstantiator(scopeType, (Instantiator)ScopeInstantiator.scopeInstantiator(scopeType), DEFAULT_REUSE_POLICY);
        }
        this.scopes.add(subScope);
        configuration.apply(scopedBuilder);
        return this;
    }

    public InjectMaidBuilder withLifecycleManagement() {
        this.lifecycleManagement = true;
        return this;
    }

    @Override
    public InjectMaidBuilder withFactory(GenericType<?> type, GenericType<?> factory, ReusePolicy reusePolicy) {
        ResolvedType resolvedType = this.reflectMaid.resolve(type);
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedType);
        ResolvedType resolvedFactory = this.reflectMaid.resolve(factory);
        this.factoryMapper.registerFactory(typeIdentifier, resolvedFactory);
        return this.withType(resolvedType, reusePolicy);
    }

    @Override
    public <X> InjectMaidBuilder withImplementation(GenericType<X> interfaceType, GenericType<? extends X> implementationType, ReusePolicy reusePolicy) {
        ResolvedType resolvedInterfaceType = this.reflectMaid.resolve(interfaceType);
        ResolvedType resolvedImplementationType = this.reflectMaid.resolve(implementationType);
        BindInstantiator instantiator = BindInstantiator.bindInstantiator(TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedImplementationType));
        this.withInstantiator(TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedInterfaceType), (Instantiator)instantiator, DEFAULT_REUSE_POLICY);
        return this.withType(TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedImplementationType), reusePolicy);
    }

    @Override
    public InjectMaidBuilder withType(GenericType<?> type, ReusePolicy reusePolicy) {
        ResolvedType resolvedType = this.reflectMaid.resolve(type);
        return this.withType(resolvedType, reusePolicy);
    }

    public InjectMaidBuilder withType(ResolvedType type, ReusePolicy reusePolicy) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)type);
        return this.withType(typeIdentifier, reusePolicy);
    }

    private InjectMaidBuilder withType(TypeIdentifier type, ReusePolicy reusePolicy) {
        this.reusePolicyMapper.registerReusePolicy(type, this.scope, reusePolicy);
        this.signals.add((Signal<InjectMaidTypeScannerResult>)AddReasonSignal.addReasonSignal((TypeIdentifier)type, (Scope)this.scope, (RequirementName)Requirements.REGISTERED, (Reason)Reason.manuallyAdded()));
        return this;
    }

    @Override
    public InjectMaidBuilder withCustomType(CustomType customType, ReusePolicy reusePolicy) {
        GenericType<?> type = customType.type();
        CustomTypeData customTypeData = customType.instantiator();
        List<TypeIdentifier> dependencies = customTypeData.dependencies().stream().map(arg_0 -> ((ReflectMaid)this.reflectMaid).resolve(arg_0)).map(TypeIdentifier::typeIdentifierFor).collect(Collectors.toList());
        CustomTypeInstantiator instantiator = CustomTypeInstantiator.customTypeInstantiator(dependencies, customTypeData.invocableFactory());
        ResolvedType resolvedType = this.reflectMaid.resolve(type);
        return this.withInstantiator(resolvedType, (Instantiator)instantiator, reusePolicy);
    }

    @Override
    public InjectMaidBuilder usingDefaultSingletonType(SingletonType singletonType) {
        this.defaultSingletonType = singletonType;
        return this;
    }

    public InjectMaidBuilder withInstantiator(ResolvedType resolvedType, Instantiator instantiator, ReusePolicy reusePolicy) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedType);
        return this.withInstantiator(typeIdentifier, instantiator, reusePolicy);
    }

    public InjectMaidBuilder withInstantiator(TypeIdentifier typeIdentifier, Instantiator instantiator, ReusePolicy reusePolicy) {
        this.withStateFactory(CustomInstantiatorFactory.customInstantiatorFactory(typeIdentifier, instantiator, this.reusePolicyMapper));
        return this.withType(typeIdentifier, reusePolicy);
    }

    public InjectMaidBuilder withStateFactory(StateFactory<InjectMaidTypeScannerResult> stateFactory) {
        List list = this.stateFactoryMap.computeIfAbsent(this.scope, x -> new ArrayList());
        list.add(stateFactory);
        return this;
    }

    public <T> InjectMaidBuilder closingInstancesOfType(Class<T> type, CloseFunction<T> closeFunction) {
        this.closers.add(Closer.closer(type, closeFunction));
        return this;
    }

    public InjectMaidBuilder closeOnJvmShutdown() {
        this.registerShutdownHook = true;
        return this;
    }

    public ReflectMaid reflectMaid() {
        return this.reflectMaid;
    }

    public InjectMaid build() {
        LifecycleManager lifecycleManager;
        StateFactories stateFactories = new StateFactories(this.stateFactoryMap, (StateFactory)new UndetectedFactory());
        Processor processor = Processor.processor((StateFactories)stateFactories, List.of(Requirements.REGISTERED), Collections.emptyList());
        InjectMaidDetector detector = InjectMaidDetector.injectMaidDetector(this.factoryMapper, this.reusePolicyMapper);
        InjectMaidResolver resolver = InjectMaidResolver.injectMaidResolver();
        InjectMaidOnCollectionError onCollectionError = InjectMaidOnCollectionError.injectMaidOnCollectionError();
        RequirementsDescriber requirementsDescriber = detectionRequirements -> "registered";
        this.signals.forEach(arg_0 -> ((Processor)processor).dispatch(arg_0));
        Map definitionsMap = processor.collect((Detector)detector, (Resolver)resolver, (OnCollectionError)onCollectionError, requirementsDescriber);
        Definitions definitions = Definitions.definitions(this.scopes.asList(), definitionsMap);
        if (this.lifecycleManagement || !this.closers.isEmpty()) {
            this.closers.add(Closer.closer(AutoCloseable.class, AutoCloseable::close));
            lifecycleManager = RealLifecycleManager.realLifecycleManager(Closers.closers(this.closers), this.scope);
        } else {
            lifecycleManager = NoOpLifecycleManager.noOpLifecycleManager();
        }
        InjectMaid injectMaid = InjectMaid.injectMaid(this.reflectMaid, definitions, this.defaultSingletonType, lifecycleManager);
        if (this.registerShutdownHook) {
            if (!this.lifecycleManagement) {
                throw InjectMaidException.injectMaidException("can only close on JVM shutdown if lifecycle management is activated");
            }
            injectMaid.registerShutdownHook();
        }
        return injectMaid;
    }

    @Generated
    private InjectMaidBuilder(ReflectMaid reflectMaid, List<Signal<InjectMaidTypeScannerResult>> signals, Map<Scope, List<StateFactory<InjectMaidTypeScannerResult>>> stateFactoryMap, FactoryMapper factoryMapper, ReusePolicyMapper reusePolicyMapper, Scope scope, Scopes scopes) {
        this.reflectMaid = reflectMaid;
        this.signals = signals;
        this.stateFactoryMap = stateFactoryMap;
        this.factoryMapper = factoryMapper;
        this.reusePolicyMapper = reusePolicyMapper;
        this.scope = scope;
        this.scopes = scopes;
    }
}

