/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.statemachine.InjectMaidTypeScannerResult;
import de.quantummaid.reflectmaid.typescanner.CollectionResult;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import de.quantummaid.reflectmaid.typescanner.scopes.Scope;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Definitions {
    private final List<Scope> scopes;
    private final Map<TypeIdentifier, List<Definition>> definitions;

    public static Definitions definitions(List<Scope> scopes, Map<TypeIdentifier, Map<Scope, CollectionResult<InjectMaidTypeScannerResult>>> definitions) {
        Map<TypeIdentifier, List<Definition>> mapOfLists = definitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Map byScope = (Map)entry.getValue();
            return byScope.values().stream().map(CollectionResult::getDefinition).map(InjectMaidTypeScannerResult::toDefinition).collect(Collectors.toList());
        }));
        return new Definitions(scopes, mapOfLists);
    }

    public boolean hasDefinitionFor(TypeIdentifier type, Scope scope) {
        if (!this.definitions.containsKey(type)) {
            return false;
        }
        return this.definitions.get(type).stream().filter(definition -> definition.scope().contains(scope)).max(Comparator.comparing(definition -> definition.scope().size())).isPresent();
    }

    public Definition definitionFor(TypeIdentifier type, Scope scope) {
        if (!this.definitions.containsKey(type)) {
            throw InjectMaidException.injectMaidException(String.format("Cannot instantiate unregistered type '%s'", type.description()));
        }
        return this.definitions.get(type).stream().filter(definition -> definition.scope().contains(scope)).max(Comparator.comparing(definition -> definition.scope().size())).orElseThrow(() -> InjectMaidException.injectMaidException(String.format("Tried to instantiate unregistered type '%s'", type.description())));
    }

    public List<Definition> definitionsOnScope(Scope scope) {
        return this.definitions.values().stream().flatMap(Collection::stream).filter(definition -> definition.scope().equals((Object)scope)).collect(Collectors.toList());
    }

    public List<Scope> allScopes() {
        return this.scopes;
    }

    public String dump() {
        return this.definitions.values().stream().flatMap(Collection::stream).map(definition -> String.format("%s %s (%s)", new Object[]{definition.scope().render(), definition.type().description(), definition.reusePolicy()})).sorted().collect(Collectors.joining("\n"));
    }

    @Generated
    public String toString() {
        return "Definitions(scopes=" + this.scopes + ", definitions=" + this.definitions + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Definitions)) {
            return false;
        }
        Definitions other = (Definitions)o;
        List<Scope> this$scopes = this.scopes;
        List<Scope> other$scopes = other.scopes;
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        Map<TypeIdentifier, List<Definition>> this$definitions = this.definitions;
        Map<TypeIdentifier, List<Definition>> other$definitions = other.definitions;
        return !(this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Scope> $scopes = this.scopes;
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        Map<TypeIdentifier, List<Definition>> $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        return result;
    }

    @Generated
    private Definitions(List<Scope> scopes, Map<TypeIdentifier, List<Definition>> definitions) {
        this.scopes = scopes;
        this.definitions = definitions;
    }
}

