/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.detection;

import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.detection.InstantiationOptions;
import de.quantummaid.injectmaid.detection.SingletonSwitch;
import de.quantummaid.injectmaid.detection.disambiguators.AnnotationDisambiguator;
import de.quantummaid.injectmaid.detection.disambiguators.DisambiguationResult;
import de.quantummaid.injectmaid.detection.disambiguators.Disambiguator;
import de.quantummaid.injectmaid.detection.disambiguators.SingleChoiceDisambiguator;
import de.quantummaid.injectmaid.detection.disambiguators.SingleConstructorDisambiguator;
import de.quantummaid.injectmaid.detection.disambiguators.SingleStaticFactoryDisambiguator;
import de.quantummaid.injectmaid.detection.singleton.AnnotationSingletonDetector;
import de.quantummaid.injectmaid.detection.singleton.SingletonDetector;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.instantiator.SelfInstantiator;
import de.quantummaid.reflectmaid.resolvedtype.ClassType;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import de.quantummaid.reflectmaid.typescanner.states.DetectionResult;
import java.util.ArrayList;
import java.util.List;

public final class Detectors {
    private static final Class<?> INJECTMAID_TYPE = InjectMaid.class;
    private static final List<Disambiguator> DISAMBIGUATORS = List.of(SingleChoiceDisambiguator.singleChoiceDisambiguator(), AnnotationDisambiguator.annotationDisambiguator(), SingleConstructorDisambiguator.singleConstructorDisambiguator(), SingleStaticFactoryDisambiguator.singleStaticFactoryDisambiguator());
    private static final List<SingletonDetector> SINGLETON_DETECTORS = List.of(AnnotationSingletonDetector.annotationSingletonDetector());

    private Detectors() {
    }

    public static DetectionResult<Instantiator> detect(TypeIdentifier typeToInstantiate, SingletonSwitch singletonSwitch) {
        if (typeToInstantiate.isVirtual()) {
            return DetectionResult.failure((String)"cannot detect virtual types");
        }
        ResolvedType resolvedType = typeToInstantiate.realType();
        return Detectors.detect(resolvedType, resolvedType, singletonSwitch);
    }

    public static DetectionResult<Instantiator> detect(TypeIdentifier typeToInstantiate, ResolvedType creatingType, SingletonSwitch singletonSwitch) {
        if (typeToInstantiate.isVirtual()) {
            return DetectionResult.failure((String)"cannot detect virtual types");
        }
        ResolvedType resolvedTypeToInstantiate = typeToInstantiate.realType();
        return Detectors.detect(resolvedTypeToInstantiate, creatingType, singletonSwitch);
    }

    private static DetectionResult<Instantiator> detect(ResolvedType typeToInstantiate, ResolvedType creatingType, SingletonSwitch singletonSwitch) {
        if (!(creatingType instanceof ClassType)) {
            return DetectionResult.failure((String)String.format("'%s' is not supported for automatic detection", creatingType.simpleDescription()));
        }
        if (typeToInstantiate.assignableType().equals(INJECTMAID_TYPE)) {
            return DetectionResult.success((Object)SelfInstantiator.selfInstantiator());
        }
        ClassType creatingClassType = (ClassType)creatingType;
        SINGLETON_DETECTORS.forEach(singletonDetector -> singletonDetector.detect(typeToInstantiate, singletonSwitch));
        InstantiationOptions instantiationOptions = InstantiationOptions.loadInstantiationOptions(typeToInstantiate, creatingClassType);
        ArrayList<String> ignoreReasons = new ArrayList<String>();
        for (Disambiguator disambiguator : DISAMBIGUATORS) {
            DisambiguationResult result = disambiguator.disambiguate(instantiationOptions);
            if (result.isSuccess()) {
                return DetectionResult.success((Object)result.instantiator());
            }
            if (result.isIgnore()) {
                ignoreReasons.add(result.ignoreMessage());
            }
            if (!result.isError()) continue;
            return Detectors.fail(typeToInstantiate, creatingType, result.errorMessage());
        }
        String combinedIgnoreReasons = String.join((CharSequence)"\n", ignoreReasons);
        return Detectors.fail(typeToInstantiate, creatingType, combinedIgnoreReasons);
    }

    private static DetectionResult<Instantiator> fail(ResolvedType typeToInstantiate, ResolvedType creatingType, String message) {
        String factoryQualifier = typeToInstantiate.equals(creatingType) ? "" : String.format(" from factory '%s'", creatingType.description());
        String errorMessage = String.format("Cannot decide how to instantiate type '%s'%s:%n%s", typeToInstantiate.description(), factoryQualifier, message);
        return DetectionResult.failure((String)errorMessage);
    }
}

