/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api.customtype.api;

import de.quantummaid.injectmaid.api.customtype.api.CustomType;
import de.quantummaid.injectmaid.api.customtype.api.CustomTypeData;
import de.quantummaid.injectmaid.api.customtype.api.InvocableFactory;
import de.quantummaid.injectmaid.namespaces.NamespacedType;
import de.quantummaid.reflectmaid.GenericType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Builder {
    private final GenericType<?> type;
    private final List<GenericType<?>> dependencies;
    private InvocableFactory<?> factory;
    private final GenericType<?> namespace;

    public static Builder builder(GenericType<?> type) {
        return Builder.builder(type, null);
    }

    public static Builder builder(GenericType<?> type, GenericType<?> namespace) {
        return new Builder(type, new ArrayList(), namespace);
    }

    public void addParameter(GenericType<?> parameter) {
        this.dependencies.add(parameter);
    }

    public void setFactory(InvocableFactory<?> factory) {
        this.factory = factory;
    }

    CustomType build() {
        CustomTypeData customTypeData;
        if (this.namespace != null) {
            List<GenericType<?>> namespacedDependencies = this.dependencies.stream().map(genericType2 -> GenericType.genericType(NamespacedType.class, (GenericType[])new GenericType[]{genericType2, this.namespace})).collect(Collectors.toList());
            InvocableFactory<Object> namespacedFactory = namespaced -> {
                Object[] unnamespaced = Arrays.stream(namespaced).map(NamespacedType.class::cast).map(NamespacedType::dependency).toArray();
                Object originalResult = this.factory.invoke(unnamespaced);
                return new NamespacedType(originalResult);
            };
            customTypeData = CustomTypeData.customTypeInstantiator(namespacedDependencies, namespacedFactory);
        } else {
            customTypeData = CustomTypeData.customTypeInstantiator(this.dependencies, this.factory);
        }
        return CustomType.customType(this.type, customTypeData);
    }

    @Generated
    public String toString() {
        return "Builder(type=" + this.type + ", dependencies=" + this.dependencies + ", factory=" + this.factory + ", namespace=" + this.namespace + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Builder)) {
            return false;
        }
        Builder other = (Builder)o;
        GenericType<?> this$type = this.type;
        GenericType<?> other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<GenericType<?>> this$dependencies = this.dependencies;
        List<GenericType<?>> other$dependencies = other.dependencies;
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        InvocableFactory<?> this$factory = this.factory;
        InvocableFactory<?> other$factory = other.factory;
        if (this$factory == null ? other$factory != null : !this$factory.equals(other$factory)) {
            return false;
        }
        GenericType<?> this$namespace = this.namespace;
        GenericType<?> other$namespace = other.namespace;
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GenericType<?> $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<GenericType<?>> $dependencies = this.dependencies;
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        InvocableFactory<?> $factory = this.factory;
        result = result * 59 + ($factory == null ? 43 : $factory.hashCode());
        GenericType<?> $namespace = this.namespace;
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }

    @Generated
    private Builder(GenericType<?> type, List<GenericType<?>> dependencies, GenericType<?> namespace) {
        this.type = type;
        this.dependencies = dependencies;
        this.namespace = namespace;
    }
}

