/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.ScopeManager;
import de.quantummaid.injectmaid.ShutdownHook;
import de.quantummaid.injectmaid.SingletonStore;
import de.quantummaid.injectmaid.api.Injector;
import de.quantummaid.injectmaid.api.SingletonType;
import de.quantummaid.injectmaid.api.interception.Interceptors;
import de.quantummaid.injectmaid.api.interception.SimpleInterceptor;
import de.quantummaid.injectmaid.api.interception.overwrite.OverwritingInterceptor;
import de.quantummaid.injectmaid.circledetector.CircularDependencyDetector;
import de.quantummaid.injectmaid.closing.Closer;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.lifecyclemanagement.ExceptionDuringClose;
import de.quantummaid.injectmaid.lifecyclemanagement.LifecycleManager;
import de.quantummaid.injectmaid.timing.InstanceAndTimedDependencies;
import de.quantummaid.injectmaid.timing.InstantiationTime;
import de.quantummaid.injectmaid.timing.InstantiationTimes;
import de.quantummaid.injectmaid.timing.TimedInstantiation;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.typescanner.TypeIdentifier;
import de.quantummaid.reflectmaid.typescanner.scopes.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InjectMaid
implements Injector {
    private final ReflectMaid reflectMaid;
    private final Definitions definitions;
    private final SingletonType defaultSingletonType;
    private final SingletonStore singletonStore;
    private final Scope scope;
    private final ScopeManager scopeManager;
    private final Interceptors interceptors;
    private final List<InjectMaid> children = new ArrayList<InjectMaid>();
    private final LifecycleManager lifecycleManager;
    private final InjectMaid parent;
    private final InstantiationTimes instantiationTimes;

    public static InjectMaidBuilder anInjectMaid() {
        ReflectMaid reflectMaid = ReflectMaid.aReflectMaid();
        return InjectMaid.anInjectMaid(reflectMaid);
    }

    public static InjectMaidBuilder anInjectMaid(ReflectMaid reflectMaid) {
        return InjectMaidBuilder.injectMaidBuilder(reflectMaid);
    }

    static InjectMaid injectMaid(ReflectMaid reflectMaid, Definitions definitions, SingletonType defaultSingletonType, LifecycleManager lifecycleManager) {
        CircularDependencyDetector.validateNoCircularDependencies(definitions);
        Scope scope = Scope.rootScope();
        ScopeManager scopeManager = ScopeManager.scopeManager();
        Interceptors interceptors = Interceptors.interceptors();
        InjectMaid injectMaid = new InjectMaid(reflectMaid, definitions, defaultSingletonType, SingletonStore.singletonStore(), scope, scopeManager, interceptors, lifecycleManager, null, InstantiationTimes.instantiationTimes(reflectMaid));
        injectMaid.loadEagerSingletons();
        return injectMaid;
    }

    @Override
    public void initializeAllSingletons() {
        this.initializeDefinitionsThat(Definition::isSingleton);
    }

    private void loadEagerSingletons() {
        this.initializeDefinitionsThat(definition -> definition.isEagerSingleton(this.defaultSingletonType));
    }

    private void initializeDefinitionsThat(Predicate<Definition> predicate) {
        this.definitions.definitionsOnScope(this.scope).stream().filter(predicate).forEach(definition -> {
            TimedInstantiation<Object> timedInstantiation = this.internalGetInstance((Definition)definition);
            InstantiationTime time = timedInstantiation.instantiationTime();
            TypeIdentifier type = definition.type();
            this.instantiationTimes.addInitializationTime(type, time);
        });
    }

    @Override
    public <T> Injector enterScope(GenericType<T> type, T scopeObject) {
        ResolvedType resolvedType = this.reflectMaid.resolve(type);
        return this.enterScope(resolvedType, scopeObject);
    }

    @Override
    public Injector enterScope(ResolvedType resolvedType, Object scopeObject) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedType);
        return this.enterScope(typeIdentifier, scopeObject);
    }

    @Override
    public Injector enterScope(TypeIdentifier typeIdentifier, Object scopeObject) {
        return this.enterScopeIfExists(typeIdentifier, scopeObject).orElseThrow(() -> {
            Scope childScope = this.scope.childScope(typeIdentifier);
            String registeredScopes = this.definitions.allScopes().stream().map(Scope::render).sorted().collect(Collectors.joining(", ", "[", "]"));
            throw InjectMaidException.injectMaidException(String.format("Tried to enter unknown scope '%s' with object '%s'. Registered scopes: %s", childScope.render(), scopeObject, registeredScopes));
        });
    }

    @Override
    public <T> Optional<Injector> enterScopeIfExists(GenericType<T> type, T scopeObject) {
        ResolvedType resolvedType = this.reflectMaid.resolve(type);
        return this.enterScopeIfExists(resolvedType, scopeObject);
    }

    @Override
    public Optional<Injector> enterScopeIfExists(ResolvedType resolvedType, Object scopeObject) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)resolvedType);
        return this.enterScopeIfExists(typeIdentifier, scopeObject);
    }

    public Optional<Injector> enterScopeIfExists(TypeIdentifier typeIdentifier, Object scopeObject) {
        Scope childScope = this.scope.childScope(typeIdentifier);
        List<Scope> scopes = this.definitions.allScopes();
        if (!scopes.contains(childScope)) {
            return Optional.empty();
        }
        SingletonStore childSingletonStore = this.singletonStore.child(typeIdentifier);
        ScopeManager childScopeManager = this.scopeManager.add(typeIdentifier, scopeObject);
        Interceptors childInterceptors = this.interceptors.enterScope(typeIdentifier, scopeObject);
        InjectMaid scopedInjectMaid = new InjectMaid(this.reflectMaid, this.definitions, this.defaultSingletonType, childSingletonStore, childScope, childScopeManager, childInterceptors, this.lifecycleManager.newInstance(childScope), this, InstantiationTimes.instantiationTimes(this.reflectMaid));
        this.children.add(scopedInjectMaid);
        scopedInjectMaid.loadEagerSingletons();
        return Optional.of(scopedInjectMaid);
    }

    @Override
    public void addInterceptor(SimpleInterceptor interceptor) {
        this.interceptors.addInterceptor(interceptor);
    }

    @Override
    public void overwriteWith(Injector injector) {
        OverwritingInterceptor interceptor = OverwritingInterceptor.overwritingInterceptor(injector);
        this.interceptors.addInterceptor(interceptor);
    }

    @Override
    public <T> T getInstance(TypeIdentifier type) {
        TimedInstantiation<T> instanceWithInitializationTime = this.getInstanceWithInitializationTime(type);
        return instanceWithInitializationTime.instance();
    }

    @Override
    public <T> TimedInstantiation<T> getInstanceWithInitializationTime(GenericType<T> type) {
        ResolvedType resolvedType = this.reflectMaid.resolve(type);
        return this.getInstanceWithInitializationTime(resolvedType);
    }

    public <T> TimedInstantiation<T> getInstanceWithInitializationTime(ResolvedType type) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor((ResolvedType)type);
        return this.getInstanceWithInitializationTime(typeIdentifier);
    }

    public <T> TimedInstantiation<T> getInstanceWithInitializationTime(TypeIdentifier type) {
        Optional<?> intercepted = this.interceptors.interceptBefore(type);
        if (intercepted.isPresent()) {
            return TimedInstantiation.timeInstantiation(type, () -> InstanceAndTimedDependencies.instanceWithNoDependencies(intercepted.get()));
        }
        Definition definition = this.definitions.definitionFor(type, this.scope);
        TimedInstantiation<Object> timedInstantiation = this.internalGetInstance(definition);
        return timedInstantiation.modify(instance -> this.interceptors.interceptAfter(type, instance));
    }

    @Override
    public boolean canInstantiate(GenericType<?> type) {
        ResolvedType resolvedType = this.reflectMaid.resolve(type);
        return this.canInstantiate(resolvedType);
    }

    @Override
    public boolean canInstantiate(TypeIdentifier type) {
        return this.definitions.hasDefinitionFor(type, this.scope);
    }

    public String debugInformation() {
        return this.definitions.dump();
    }

    private TimedInstantiation<Object> internalGetInstance(Definition definition) {
        return this.createAndRegister(definition);
    }

    private TimedInstantiation<Object> instantiate(Definition definition) {
        Instantiator instantiator = definition.instantiator();
        return TimedInstantiation.timeInstantiation(definition.type(), () -> {
            List<TimedInstantiation<?>> timedDependencies = this.instantiateDependencies(instantiator);
            List<Object> dependencies = timedDependencies.stream().map(TimedInstantiation::instance).collect(Collectors.toList());
            List<InstantiationTime> dependenciesInstantiationTimes = timedDependencies.stream().map(TimedInstantiation::instantiationTime).collect(Collectors.toList());
            try {
                Object instance = instantiator.instantiate(dependencies, this.scopeManager, this);
                return InstanceAndTimedDependencies.instanceAndTimedDependencies(instance, dependenciesInstantiationTimes);
            }
            catch (Exception e) {
                throw InjectMaidException.injectMaidException(String.format("Exception during instantiation of '%s' using %s", definition.type().simpleDescription(), instantiator.description()), e);
            }
        });
    }

    private List<TimedInstantiation<?>> instantiateDependencies(Instantiator instantiator) {
        return instantiator.dependencies().stream().map(this::getInstanceWithInitializationTime).collect(Collectors.toList());
    }

    private TimedInstantiation<Object> createAndRegister(Definition definition) {
        boolean singleton = definition.isSingleton();
        TypeIdentifier type = definition.type();
        Scope definitionScope = definition.scope();
        if (singleton && this.singletonStore.contains(type, definitionScope)) {
            return TimedInstantiation.timeInstantiation(definition.type(), () -> InstanceAndTimedDependencies.instanceWithNoDependencies(this.singletonStore.get(type, definitionScope)));
        }
        TimedInstantiation<Object> instance = this.instantiate(definition);
        this.lifecycleManager.registerInstance(instance.instance(), definitionScope);
        if (singleton) {
            this.singletonStore.put(type, definitionScope, instance.instance());
        }
        return instance;
    }

    public InstantiationTimes instantiationTimes() {
        return this.instantiationTimes;
    }

    void registerShutdownHook() {
        ShutdownHook shutdownHook = ShutdownHook.shutdownHook(this);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.lifecycleManager.registerInstance(shutdownHook, this.scope);
    }

    public void registerExternalObjectToLifecycleManagement(Object object) {
        this.lifecycleManager.registerInstance(object, this.scope);
    }

    @Override
    public void close() {
        Closer.close(this::close);
    }

    private void close(List<ExceptionDuringClose> exceptions) {
        ArrayList<InjectMaid> childrenToClose = new ArrayList<InjectMaid>(this.children);
        childrenToClose.forEach(injectMaid -> injectMaid.close(exceptions));
        this.lifecycleManager.closeAll(exceptions);
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
    }

    @Override
    public ReflectMaid reflectMaid() {
        return this.reflectMaid;
    }

    @Generated
    private InjectMaid(ReflectMaid reflectMaid, Definitions definitions, SingletonType defaultSingletonType, SingletonStore singletonStore, Scope scope, ScopeManager scopeManager, Interceptors interceptors, LifecycleManager lifecycleManager, InjectMaid parent, InstantiationTimes instantiationTimes) {
        this.reflectMaid = reflectMaid;
        this.definitions = definitions;
        this.defaultSingletonType = defaultSingletonType;
        this.singletonStore = singletonStore;
        this.scope = scope;
        this.scopeManager = scopeManager;
        this.interceptors = interceptors;
        this.lifecycleManager = lifecycleManager;
        this.parent = parent;
        this.instantiationTimes = instantiationTimes;
    }
}

