/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api;

import de.quantummaid.injectmaid.InjectMaid;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.api.InjectorConfiguration;
import de.quantummaid.injectmaid.api.interception.SimpleInterceptor;
import de.quantummaid.injectmaid.timing.TimedInstantiation;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Optional;

public interface Injector
extends AutoCloseable {
    default public <T> T getInstance(Class<T> type) {
        GenericType genericType = GenericType.genericType(type);
        return this.getInstance(genericType);
    }

    default public <T> T getInstance(GenericType<T> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return (T)this.getInstance(resolvedType);
    }

    default public Object getInstance(ResolvedType type) {
        TimedInstantiation<Object> instanceWithInitializationTime = this.getInstanceWithInitializationTime(type);
        return instanceWithInitializationTime.instance();
    }

    default public <T> TimedInstantiation<T> getInstanceWithInitializationTime(Class<T> type) {
        GenericType genericType = GenericType.genericType(type);
        return this.getInstanceWithInitializationTime(genericType);
    }

    default public <T> TimedInstantiation<T> getInstanceWithInitializationTime(GenericType<T> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return this.getInstanceWithInitializationTime(resolvedType);
    }

    public TimedInstantiation<Object> getInstanceWithInitializationTime(ResolvedType var1);

    public void initializeAllSingletons();

    default public Injector enterScope(Object scopeObject) {
        Class<?> scopeType = scopeObject.getClass();
        return this.enterScope(scopeType, scopeObject);
    }

    default public <T> Injector enterScope(Class<T> scopeType, T scopeObject) {
        GenericType genericType = GenericType.genericType(scopeType);
        return this.enterScope(genericType, scopeObject);
    }

    default public <T> Injector enterScope(GenericType<T> scopeType, T scopeObject) {
        ResolvedType resolvedType = scopeType.toResolvedType();
        return this.enterScope(resolvedType, scopeObject);
    }

    public Injector enterScope(ResolvedType var1, Object var2);

    default public Optional<Injector> enterScopeIfExists(Object scopeObject) {
        Class<?> scopeType = scopeObject.getClass();
        return this.enterScopeIfExists(scopeType, scopeObject);
    }

    default public <T> Optional<Injector> enterScopeIfExists(Class<T> scopeType, T scopeObject) {
        GenericType genericType = GenericType.genericType(scopeType);
        return this.enterScopeIfExists(genericType, scopeObject);
    }

    default public <T> Optional<Injector> enterScopeIfExists(GenericType<T> scopeType, T scopeObject) {
        ResolvedType resolvedType = scopeType.toResolvedType();
        return this.enterScopeIfExists(resolvedType, scopeObject);
    }

    public Optional<Injector> enterScopeIfExists(ResolvedType var1, Object var2);

    public void addInterceptor(SimpleInterceptor var1);

    default public void overwriteWith(InjectorConfiguration injectorConfiguration) {
        InjectMaidBuilder builder = InjectMaid.anInjectMaid();
        injectorConfiguration.apply(builder);
        InjectMaid injectMaid = builder.build();
        this.overwriteWith(injectMaid);
    }

    public void overwriteWith(Injector var1);

    default public boolean canInstantiate(Class<?> type) {
        GenericType genericType = GenericType.genericType(type);
        return this.canInstantiate(genericType);
    }

    default public boolean canInstantiate(GenericType<?> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return this.canInstantiate(resolvedType);
    }

    public boolean canInstantiate(ResolvedType var1);

    @Override
    public void close();
}

