/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.statemachine.states;

import de.quantummaid.injectmaid.api.ReusePolicy;
import de.quantummaid.injectmaid.detection.DetectionResult;
import de.quantummaid.injectmaid.detection.Detectors;
import de.quantummaid.injectmaid.detection.SingletonSwitch;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.statemachine.Context;
import de.quantummaid.injectmaid.statemachine.states.Failed;
import de.quantummaid.injectmaid.statemachine.states.ResolvingDependencies;
import de.quantummaid.injectmaid.statemachine.states.State;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import lombok.Generated;

public final class UnresolvedFactory
implements State {
    private final Context context;
    private final ResolvedType factoryType;

    public static UnresolvedFactory unresolvedFactory(Context context, ResolvedType factoryType) {
        NotNullValidator.validateNotNull((Object)context, (String)"context");
        NotNullValidator.validateNotNull((Object)factoryType, (String)"factoryType");
        return new UnresolvedFactory(context, factoryType);
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public State detectInstantiator() {
        ReusePolicy oldReusePolicy;
        SingletonSwitch singletonSwitch;
        ResolvedType type = this.context.type();
        DetectionResult result = Detectors.detect(type, this.factoryType, singletonSwitch = SingletonSwitch.singletonSwitch(oldReusePolicy = this.context.reusePolicy()));
        if (result.isFailure()) {
            this.context.setErrorMessage(result.errorMessage());
            return Failed.failed(this.context);
        }
        Instantiator instantiator = result.instantiator();
        this.context.setInstantiator(instantiator);
        ReusePolicy newReusePolicy = singletonSwitch.getReusePolicy();
        this.context.setReusePolicy(newReusePolicy);
        return ResolvingDependencies.resolvingDependencies(this.context);
    }

    @Generated
    public String toString() {
        return "UnresolvedFactory(context=" + this.context + ", factoryType=" + this.factoryType + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnresolvedFactory)) {
            return false;
        }
        UnresolvedFactory other = (UnresolvedFactory)o;
        Context this$context = this.context;
        Context other$context = other.context;
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        ResolvedType this$factoryType = this.factoryType;
        ResolvedType other$factoryType = other.factoryType;
        return !(this$factoryType == null ? other$factoryType != null : !this$factoryType.equals(other$factoryType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.context;
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        ResolvedType $factoryType = this.factoryType;
        result = result * 59 + ($factoryType == null ? 43 : $factoryType.hashCode());
        return result;
    }

    @Generated
    private UnresolvedFactory(Context context, ResolvedType factoryType) {
        this.context = context;
        this.factoryType = factoryType;
    }
}

