/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.detection;

import de.quantummaid.injectmaid.instantiator.ConstructorInstantiator;
import de.quantummaid.injectmaid.instantiator.NonStaticFactoryInstantiator;
import de.quantummaid.injectmaid.instantiator.StaticFactoryInstantiator;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InstantiationOptions {
    private final List<ConstructorInstantiator> constructors;
    private final List<StaticFactoryInstantiator> staticFactoryMethods;
    private final List<NonStaticFactoryInstantiator> nonStaticFactoryMethods;

    public static InstantiationOptions loadInstantiationOptions(ResolvedType typeToInstantiate, ClassType creatingClassType) {
        List<NonStaticFactoryInstantiator> nonStaticFactoryMethods;
        List<ConstructorInstantiator> constructors;
        if (typeToInstantiate.equals(creatingClassType)) {
            constructors = creatingClassType.constructors().stream().filter(ResolvedConstructor::isPublic).map(ConstructorInstantiator::constructorInstantiator).collect(Collectors.toList());
            nonStaticFactoryMethods = Collections.emptyList();
        } else {
            constructors = Collections.emptyList();
            nonStaticFactoryMethods = creatingClassType.methods().stream().filter(method -> !Modifier.isStatic(method.method().getModifiers())).filter(method -> method.returnType().map(typeToInstantiate::equals).orElse(false)).map(method -> NonStaticFactoryInstantiator.nonStaticFactoryInstantiator(method, (ResolvedType)creatingClassType)).collect(Collectors.toList());
        }
        List<StaticFactoryInstantiator> factoryMethods = creatingClassType.methods().stream().filter(ResolvedMethod::isPublic).filter(method -> Modifier.isStatic(method.method().getModifiers())).filter(method -> method.returnType().map(typeToInstantiate::equals).orElse(false)).map(StaticFactoryInstantiator::staticFactoryInstantiator).collect(Collectors.toList());
        return new InstantiationOptions(constructors, factoryMethods, nonStaticFactoryMethods);
    }

    public List<ConstructorInstantiator> constructors() {
        return this.constructors;
    }

    public List<StaticFactoryInstantiator> staticFactoryMethods() {
        return this.staticFactoryMethods;
    }

    public List<NonStaticFactoryInstantiator> nonStaticFactoryMethods() {
        return this.nonStaticFactoryMethods;
    }

    @Generated
    public String toString() {
        return "InstantiationOptions(constructors=" + this.constructors + ", staticFactoryMethods=" + this.staticFactoryMethods + ", nonStaticFactoryMethods=" + this.nonStaticFactoryMethods + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstantiationOptions)) {
            return false;
        }
        InstantiationOptions other = (InstantiationOptions)o;
        List<ConstructorInstantiator> this$constructors = this.constructors;
        List<ConstructorInstantiator> other$constructors = other.constructors;
        if (this$constructors == null ? other$constructors != null : !((Object)this$constructors).equals(other$constructors)) {
            return false;
        }
        List<StaticFactoryInstantiator> this$staticFactoryMethods = this.staticFactoryMethods;
        List<StaticFactoryInstantiator> other$staticFactoryMethods = other.staticFactoryMethods;
        if (this$staticFactoryMethods == null ? other$staticFactoryMethods != null : !((Object)this$staticFactoryMethods).equals(other$staticFactoryMethods)) {
            return false;
        }
        List<NonStaticFactoryInstantiator> this$nonStaticFactoryMethods = this.nonStaticFactoryMethods;
        List<NonStaticFactoryInstantiator> other$nonStaticFactoryMethods = other.nonStaticFactoryMethods;
        return !(this$nonStaticFactoryMethods == null ? other$nonStaticFactoryMethods != null : !((Object)this$nonStaticFactoryMethods).equals(other$nonStaticFactoryMethods));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ConstructorInstantiator> $constructors = this.constructors;
        result = result * 59 + ($constructors == null ? 43 : ((Object)$constructors).hashCode());
        List<StaticFactoryInstantiator> $staticFactoryMethods = this.staticFactoryMethods;
        result = result * 59 + ($staticFactoryMethods == null ? 43 : ((Object)$staticFactoryMethods).hashCode());
        List<NonStaticFactoryInstantiator> $nonStaticFactoryMethods = this.nonStaticFactoryMethods;
        result = result * 59 + ($nonStaticFactoryMethods == null ? 43 : ((Object)$nonStaticFactoryMethods).hashCode());
        return result;
    }

    @Generated
    private InstantiationOptions(List<ConstructorInstantiator> constructors, List<StaticFactoryInstantiator> staticFactoryMethods, List<NonStaticFactoryInstantiator> nonStaticFactoryMethods) {
        this.constructors = constructors;
        this.staticFactoryMethods = staticFactoryMethods;
        this.nonStaticFactoryMethods = nonStaticFactoryMethods;
    }
}

