/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Scope {
    private final List<ResolvedType> scope;

    public static Scope rootScope() {
        return new Scope(Collections.emptyList());
    }

    public Scope childScope(ResolvedType subScope) {
        NotNullValidator.validateNotNull((Object)subScope, (String)"subScope");
        ArrayList<ResolvedType> newScope = new ArrayList<ResolvedType>(this.scope);
        newScope.add(subScope);
        return new Scope(newScope);
    }

    public String render() {
        return this.scope.stream().map(ResolvedType::simpleDescription).collect(Collectors.joining("/", "/", ""));
    }

    public int size() {
        return this.scope.size();
    }

    public boolean containsElement(ResolvedType type) {
        return this.scope.contains(type);
    }

    public boolean contains(Scope other) {
        if (this.size() > other.size()) {
            return false;
        }
        for (int i = 0; i < this.scope.size(); ++i) {
            ResolvedType otherPart;
            ResolvedType thisPart = this.scope.get(i);
            if (thisPart.equals(otherPart = other.scope.get(i))) continue;
            return false;
        }
        return true;
    }

    @Generated
    public String toString() {
        return "Scope(scope=" + this.scope + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)o;
        List<ResolvedType> this$scope = this.scope;
        List<ResolvedType> other$scope = other.scope;
        return !(this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ResolvedType> $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        return result;
    }

    @Generated
    private Scope(List<ResolvedType> scope) {
        this.scope = scope;
    }
}

