/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.statemachine;

import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.Scope;
import de.quantummaid.injectmaid.api.ReusePolicy;
import de.quantummaid.injectmaid.statemachine.Context;
import de.quantummaid.injectmaid.statemachine.states.State;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class States {
    private final List<State> states;
    private final List<State> newStates;

    public static States states() {
        return new States(new ArrayList<State>(), new ArrayList<State>());
    }

    public void addIfNotPresent(State state) {
        Context context = state.context();
        if (!this.contains(context.type(), context.scope())) {
            this.newStates.add(state);
        }
    }

    public void addOrFailIfAlreadyPresent(State state, boolean allowDuplicatesIfSame) {
        ReusePolicy reusePolicy;
        Scope scope;
        Context context = state.context();
        ResolvedType type = context.type();
        if (this.containsExactly(type, scope = context.scope(), reusePolicy = context.reusePolicy(), allowDuplicatesIfSame)) {
            throw InjectMaidException.injectMaidException(String.format("Type '%s' has already been registered in scope '%s'", type.description(), scope.render()));
        }
        this.newStates.add(state);
    }

    public void update(UnaryOperator<State> signal) {
        this.states.stream().map(signal).forEach(this.newStates::add);
        this.states.clear();
        this.states.addAll(this.newStates);
        this.newStates.clear();
    }

    public boolean allFinal() {
        if (!this.newStates.isEmpty()) {
            return false;
        }
        return this.states.stream().allMatch(State::isFinal);
    }

    public <T> Stream<T> collect(Function<State, T> mapper) {
        return this.states.stream().map(mapper);
    }

    private boolean containsExactly(ResolvedType type, Scope scope, ReusePolicy reusePolicy, boolean allowDuplicatesIfSame) {
        List matchingTypes = this.newStates.stream().map(State::context).filter(context -> context.type().equals(type)).filter(context -> context.scope().equals(scope)).collect(Collectors.toList());
        if (allowDuplicatesIfSame) {
            return matchingTypes.stream().anyMatch(context -> context.reusePolicy() != reusePolicy);
        }
        return !matchingTypes.isEmpty();
    }

    private boolean contains(ResolvedType type, Scope scope) {
        boolean contains = this.states.stream().anyMatch(state -> state.matches(type, scope));
        if (contains) {
            return true;
        }
        return this.newStates.stream().anyMatch(state -> state.matches(type, scope));
    }

    @Generated
    public String toString() {
        return "States(states=" + this.states + ", newStates=" + this.newStates + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof States)) {
            return false;
        }
        States other = (States)o;
        List<State> this$states = this.states;
        List<State> other$states = other.states;
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        List<State> this$newStates = this.newStates;
        List<State> other$newStates = other.newStates;
        return !(this$newStates == null ? other$newStates != null : !((Object)this$newStates).equals(other$newStates));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<State> $states = this.states;
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        List<State> $newStates = this.newStates;
        result = result * 59 + ($newStates == null ? 43 : ((Object)$newStates).hashCode());
        return result;
    }

    @Generated
    private States(List<State> states, List<State> newStates) {
        this.states = states;
        this.newStates = newStates;
    }
}

