/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.api;

import de.quantummaid.injectmaid.api.interception.SimpleInterceptor;
import de.quantummaid.injectmaid.timing.TimedInstantiation;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;

public interface Injector
extends AutoCloseable {
    default public <T> T getInstance(Class<T> type) {
        GenericType genericType = GenericType.genericType(type);
        return this.getInstance(genericType);
    }

    default public <T> T getInstance(GenericType<T> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return (T)this.getInstance(resolvedType);
    }

    default public Object getInstance(ResolvedType type) {
        TimedInstantiation<Object> instanceWithInitializationTime = this.getInstanceWithInitializationTime(type);
        return instanceWithInitializationTime.instance();
    }

    default public <T> TimedInstantiation<T> getInstanceWithInitializationTime(Class<T> type) {
        GenericType genericType = GenericType.genericType(type);
        return this.getInstanceWithInitializationTime(genericType);
    }

    default public <T> TimedInstantiation<T> getInstanceWithInitializationTime(GenericType<T> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return this.getInstanceWithInitializationTime(resolvedType);
    }

    public TimedInstantiation<Object> getInstanceWithInitializationTime(ResolvedType var1);

    public void initializeAllSingletons();

    default public Injector enterScope(Object scopeObject) {
        Class<?> scopeType = scopeObject.getClass();
        return this.enterScope(scopeType, scopeObject);
    }

    default public <T> Injector enterScope(Class<T> scopeType, T scopeObject) {
        GenericType genericType = GenericType.genericType(scopeType);
        return this.enterScope(genericType, scopeObject);
    }

    default public <T> Injector enterScope(GenericType<T> scopeType, T scopeObject) {
        ResolvedType resolvedType = scopeType.toResolvedType();
        return this.enterScope(resolvedType, scopeObject);
    }

    public Injector enterScope(ResolvedType var1, Object var2);

    public void addInterceptor(SimpleInterceptor var1);

    public void overwriteWith(Injector var1);

    default public boolean canInstantiate(Class<?> type) {
        GenericType genericType = GenericType.genericType(type);
        return this.canInstantiate(genericType);
    }

    default public boolean canInstantiate(GenericType<?> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return this.canInstantiate(resolvedType);
    }

    public boolean canInstantiate(ResolvedType var1);

    @Override
    public void close();
}

