/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.Scope;
import de.quantummaid.injectmaid.ScopeManager;
import de.quantummaid.injectmaid.SingletonStore;
import de.quantummaid.injectmaid.api.Injector;
import de.quantummaid.injectmaid.api.SingletonType;
import de.quantummaid.injectmaid.api.interception.Interceptors;
import de.quantummaid.injectmaid.api.interception.SimpleInterceptor;
import de.quantummaid.injectmaid.api.interception.overwrite.OverwritingInterceptor;
import de.quantummaid.injectmaid.circledetector.CircularDependencyDetector;
import de.quantummaid.injectmaid.closing.Closer;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.lifecyclemanagement.ExceptionDuringClose;
import de.quantummaid.injectmaid.lifecyclemanagement.LifecycleManager;
import de.quantummaid.injectmaid.timing.InstanceAndTimedDependencies;
import de.quantummaid.injectmaid.timing.InstantiationTime;
import de.quantummaid.injectmaid.timing.InstantiationTimes;
import de.quantummaid.injectmaid.timing.TimedInstantiation;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InjectMaid
implements Injector {
    private final Definitions definitions;
    private final SingletonType defaultSingletonType;
    private final SingletonStore singletonStore;
    private final Scope scope;
    private final ScopeManager scopeManager;
    private final Interceptors interceptors;
    private final List<InjectMaid> children = new ArrayList<InjectMaid>();
    private final LifecycleManager lifecycleManager;
    private final InjectMaid parent;
    private final InstantiationTimes instantiationTimes = InstantiationTimes.instantiationTimes();

    public static InjectMaidBuilder anInjectMaid() {
        return InjectMaidBuilder.injectionMaidBuilder();
    }

    static InjectMaid injectMaid(Definitions definitions, SingletonType defaultSingletonType, LifecycleManager lifecycleManager) {
        CircularDependencyDetector.validateNoCircularDependencies(definitions);
        Scope scope = Scope.rootScope();
        ScopeManager scopeManager = ScopeManager.scopeManager();
        Interceptors interceptors = Interceptors.interceptors();
        return InjectMaid.initInScope(definitions, defaultSingletonType, scope, scopeManager, interceptors, lifecycleManager, null);
    }

    private static InjectMaid initInScope(Definitions definitions, SingletonType defaultSingletonType, Scope scope, ScopeManager scopeManager, Interceptors interceptors, LifecycleManager lifecycleManager, InjectMaid parent) {
        SingletonStore singletonStore = SingletonStore.singletonStore();
        InjectMaid injectMaid = new InjectMaid(definitions, defaultSingletonType, singletonStore, scope, scopeManager, interceptors, lifecycleManager, parent);
        injectMaid.loadEagerSingletons();
        return injectMaid;
    }

    @Override
    public void initializeAllSingletons() {
        this.initializeDefinitionsThat(Definition::isSingleton);
    }

    private void loadEagerSingletons() {
        this.initializeDefinitionsThat(definition -> definition.isEagerSingleton(this.defaultSingletonType));
    }

    private void initializeDefinitionsThat(Predicate<Definition> predicate) {
        this.definitions.definitionsOnScope(this.scope).stream().filter(predicate).forEach(definition -> {
            TimedInstantiation<Object> timedInstantiation = this.internalGetInstance((Definition)definition);
            InstantiationTime time = timedInstantiation.instantiationTime();
            ResolvedType type = definition.type();
            this.instantiationTimes.addInitializationTime(GenericType.fromResolvedType((ResolvedType)type), time);
        });
    }

    @Override
    public InjectMaid enterScope(ResolvedType resolvedType, Object scopeObject) {
        Scope childScope = this.scope.childScope(resolvedType);
        List<Scope> scopes = this.definitions.allScopes();
        if (!scopes.contains(childScope)) {
            String registeredScopes = scopes.stream().map(Scope::render).sorted().collect(Collectors.joining(", ", "[", "]"));
            throw InjectMaidException.injectMaidException(String.format("Tried to enter unknown scope '%s' with object '%s'. Registered scopes: %s", childScope.render(), scopeObject, registeredScopes));
        }
        SingletonStore childSingletonStore = this.singletonStore.child(resolvedType);
        ScopeManager childScopeManager = this.scopeManager.add(resolvedType, scopeObject);
        Interceptors childInterceptors = this.interceptors.enterScope(resolvedType, scopeObject);
        InjectMaid scopedInjectMaid = new InjectMaid(this.definitions, this.defaultSingletonType, childSingletonStore, childScope, childScopeManager, childInterceptors, this.lifecycleManager.newInstance(), this);
        this.children.add(scopedInjectMaid);
        return scopedInjectMaid;
    }

    @Override
    public void addInterceptor(SimpleInterceptor interceptor) {
        this.interceptors.addInterceptor(interceptor);
    }

    @Override
    public void overwriteWith(Injector injector) {
        OverwritingInterceptor interceptor = OverwritingInterceptor.overwritingInterceptor(injector);
        this.interceptors.addInterceptor(interceptor);
    }

    @Override
    public TimedInstantiation<Object> getInstanceWithInitializationTime(ResolvedType type) {
        Optional<?> intercepted = this.interceptors.interceptBefore(type);
        if (intercepted.isPresent()) {
            return TimedInstantiation.timeInstantiation(GenericType.fromResolvedType((ResolvedType)type), () -> InstanceAndTimedDependencies.instanceWithNoDependencies(intercepted.get()));
        }
        Definition definition = this.definitions.definitionFor(type, this.scope);
        TimedInstantiation<Object> timedInstantiation = this.internalGetInstance(definition);
        return timedInstantiation.modify(instance -> {
            Object interceptedInstance = this.interceptors.interceptAfter(type, instance);
            this.lifecycleManager.registerInstance(interceptedInstance);
            return interceptedInstance;
        });
    }

    @Override
    public boolean canInstantiate(ResolvedType resolvedType) {
        return this.definitions.hasDefinitionFor(resolvedType, this.scope);
    }

    public String debugInformation() {
        return this.definitions.dump();
    }

    private TimedInstantiation<Object> internalGetInstance(Definition definition) {
        return this.createAndRegister(definition);
    }

    private TimedInstantiation<Object> instantiate(Definition definition) {
        Instantiator instantiator = definition.instantiator();
        return TimedInstantiation.timeInstantiation(GenericType.fromResolvedType((ResolvedType)definition.type()), () -> {
            List<TimedInstantiation<?>> timedDependencies = this.instantiateDependencies(instantiator);
            List<Object> dependencies = timedDependencies.stream().map(TimedInstantiation::instance).collect(Collectors.toList());
            List<InstantiationTime> dependenciesInstantiationTimes = timedDependencies.stream().map(TimedInstantiation::instantiationTime).collect(Collectors.toList());
            try {
                Object instance = instantiator.instantiate(dependencies, this.scopeManager, this);
                return InstanceAndTimedDependencies.instanceAndTimedDependencies(instance, dependenciesInstantiationTimes);
            }
            catch (Exception e) {
                throw InjectMaidException.injectMaidException(String.format("Exception during instantiation of '%s' using %s", definition.type().simpleDescription(), instantiator.description()), e);
            }
        });
    }

    private List<TimedInstantiation<?>> instantiateDependencies(Instantiator instantiator) {
        return instantiator.dependencies().stream().map(this::getInstanceWithInitializationTime).collect(Collectors.toList());
    }

    private TimedInstantiation<Object> createAndRegister(Definition definition) {
        boolean singleton = definition.isSingleton();
        ResolvedType type = definition.type();
        Scope definitionScope = definition.scope();
        if (singleton && this.singletonStore.contains(type, definitionScope)) {
            return TimedInstantiation.timeInstantiation(GenericType.fromResolvedType((ResolvedType)definition.type()), () -> InstanceAndTimedDependencies.instanceWithNoDependencies(this.singletonStore.get(type, definitionScope)));
        }
        TimedInstantiation<Object> instance = this.instantiate(definition);
        if (singleton) {
            this.singletonStore.put(type, definitionScope, instance.instance());
        }
        return instance;
    }

    public InstantiationTimes instantiationTimes() {
        return this.instantiationTimes;
    }

    @Override
    public void close() {
        Closer.close(this::close);
    }

    private void close(List<ExceptionDuringClose> exceptions) {
        ArrayList<InjectMaid> childrenToClose = new ArrayList<InjectMaid>(this.children);
        childrenToClose.forEach(injectMaid -> injectMaid.close(exceptions));
        this.lifecycleManager.closeAll(exceptions);
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
    }

    @Generated
    public String toString() {
        return "InjectMaid(definitions=" + this.definitions + ", defaultSingletonType=" + this.defaultSingletonType + ", singletonStore=" + this.singletonStore + ", scope=" + this.scope + ", scopeManager=" + this.scopeManager + ", interceptors=" + this.interceptors + ", children=" + this.children + ", lifecycleManager=" + this.lifecycleManager + ", parent=" + this.parent + ", instantiationTimes=" + this.instantiationTimes + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InjectMaid)) {
            return false;
        }
        InjectMaid other = (InjectMaid)o;
        Definitions this$definitions = this.definitions;
        Definitions other$definitions = other.definitions;
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        SingletonType this$defaultSingletonType = this.defaultSingletonType;
        SingletonType other$defaultSingletonType = other.defaultSingletonType;
        if (this$defaultSingletonType == null ? other$defaultSingletonType != null : !((Object)((Object)this$defaultSingletonType)).equals((Object)other$defaultSingletonType)) {
            return false;
        }
        SingletonStore this$singletonStore = this.singletonStore;
        SingletonStore other$singletonStore = other.singletonStore;
        if (this$singletonStore == null ? other$singletonStore != null : !((Object)this$singletonStore).equals(other$singletonStore)) {
            return false;
        }
        Scope this$scope = this.scope;
        Scope other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        ScopeManager this$scopeManager = this.scopeManager;
        ScopeManager other$scopeManager = other.scopeManager;
        if (this$scopeManager == null ? other$scopeManager != null : !((Object)this$scopeManager).equals(other$scopeManager)) {
            return false;
        }
        Interceptors this$interceptors = this.interceptors;
        Interceptors other$interceptors = other.interceptors;
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        List<InjectMaid> this$children = this.children;
        List<InjectMaid> other$children = other.children;
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        LifecycleManager this$lifecycleManager = this.lifecycleManager;
        LifecycleManager other$lifecycleManager = other.lifecycleManager;
        if (this$lifecycleManager == null ? other$lifecycleManager != null : !this$lifecycleManager.equals(other$lifecycleManager)) {
            return false;
        }
        InjectMaid this$parent = this.parent;
        InjectMaid other$parent = other.parent;
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        InstantiationTimes this$instantiationTimes = this.instantiationTimes;
        InstantiationTimes other$instantiationTimes = other.instantiationTimes;
        return !(this$instantiationTimes == null ? other$instantiationTimes != null : !this$instantiationTimes.equals(other$instantiationTimes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Definitions $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        SingletonType $defaultSingletonType = this.defaultSingletonType;
        result = result * 59 + ($defaultSingletonType == null ? 43 : ((Object)((Object)$defaultSingletonType)).hashCode());
        SingletonStore $singletonStore = this.singletonStore;
        result = result * 59 + ($singletonStore == null ? 43 : ((Object)$singletonStore).hashCode());
        Scope $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        ScopeManager $scopeManager = this.scopeManager;
        result = result * 59 + ($scopeManager == null ? 43 : ((Object)$scopeManager).hashCode());
        Interceptors $interceptors = this.interceptors;
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        List<InjectMaid> $children = this.children;
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        LifecycleManager $lifecycleManager = this.lifecycleManager;
        result = result * 59 + ($lifecycleManager == null ? 43 : $lifecycleManager.hashCode());
        InjectMaid $parent = this.parent;
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        InstantiationTimes $instantiationTimes = this.instantiationTimes;
        result = result * 59 + ($instantiationTimes == null ? 43 : $instantiationTimes.hashCode());
        return result;
    }

    @Generated
    private InjectMaid(Definitions definitions, SingletonType defaultSingletonType, SingletonStore singletonStore, Scope scope, ScopeManager scopeManager, Interceptors interceptors, LifecycleManager lifecycleManager, InjectMaid parent) {
        this.definitions = definitions;
        this.defaultSingletonType = defaultSingletonType;
        this.singletonStore = singletonStore;
        this.scope = scope;
        this.scopeManager = scopeManager;
        this.interceptors = interceptors;
        this.lifecycleManager = lifecycleManager;
        this.parent = parent;
    }
}

