/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.statemachine;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.ReusePolicy;
import de.quantummaid.injectmaid.Scope;
import de.quantummaid.injectmaid.statemachine.States;
import de.quantummaid.injectmaid.statemachine.states.State;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StateMachineRunner {
    private StateMachineRunner() {
    }

    public static Map<ResolvedType, List<Definition>> runStateMachine(States states) {
        while (!states.allFinal()) {
            states.update(State::detectInstantiator);
            states.update(State::resolvedDependencies);
        }
        HashMap<ResolvedType, List<Definition>> definitionsMap = new HashMap<ResolvedType, List<Definition>>();
        ArrayList errors = new ArrayList();
        states.collect(State::context).forEach(context -> {
            ResolvedType type = context.type();
            Scope scopeOfType = context.scope();
            context.instantiator().ifPresentOrElse(instantiator -> {
                ReusePolicy reusePolicy = context.reusePolicy();
                Definition definition = Definition.definition(type, scopeOfType, instantiator, reusePolicy);
                if (!definitionsMap.containsKey(type)) {
                    definitionsMap.put(type, new ArrayList(1));
                }
                ((List)definitionsMap.get(type)).add(definition);
            }, () -> {
                String errorMessage = context.errorMessage();
                errors.add(errorMessage);
            });
        });
        if (!errors.isEmpty()) {
            String joinedErrors = String.join((CharSequence)"\n\n", errors);
            throw InjectMaidException.injectMaidException(joinedErrors);
        }
        return definitionsMap;
    }
}

