/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.Injector;
import de.quantummaid.injectmaid.ReusePolicy;
import de.quantummaid.injectmaid.Scope;
import de.quantummaid.injectmaid.ScopeManager;
import de.quantummaid.injectmaid.SingletonStore;
import de.quantummaid.injectmaid.SingletonType;
import de.quantummaid.injectmaid.circledetector.CircularDependencyDetector;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.interception.Interceptor;
import de.quantummaid.injectmaid.interception.Interceptors;
import de.quantummaid.injectmaid.interception.SimpleInterceptor;
import de.quantummaid.injectmaid.interception.overwrite.OverwritingInterceptor;
import de.quantummaid.injectmaid.lifecyclemanagement.ExceptionDuringClose;
import de.quantummaid.injectmaid.lifecyclemanagement.LifecycleManager;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InjectMaid
implements Injector {
    private final Definitions definitions;
    private final SingletonType defaultSingletonType;
    private final SingletonStore singletonStore;
    private final Scope scope;
    private final ScopeManager scopeManager;
    private final Interceptors interceptors;
    private final List<InjectMaid> children = new ArrayList<InjectMaid>();
    private final LifecycleManager lifecycleManager;

    public static InjectMaidBuilder anInjectMaid() {
        return InjectMaidBuilder.injectionMaidBuilder();
    }

    static InjectMaid injectMaid(Definitions definitions, SingletonType defaultSingletonType, LifecycleManager lifecycleManager) {
        CircularDependencyDetector.validateNoCircularDependencies(definitions);
        Scope scope = Scope.rootScope();
        ScopeManager scopeManager = ScopeManager.scopeManager();
        Interceptors interceptors = Interceptors.interceptors();
        return InjectMaid.initInScope(definitions, defaultSingletonType, scope, scopeManager, interceptors, lifecycleManager);
    }

    private static InjectMaid initInScope(Definitions definitions, SingletonType defaultSingletonType, Scope scope, ScopeManager scopeManager, Interceptors interceptors, LifecycleManager lifecycleManager) {
        SingletonStore singletonStore = SingletonStore.singletonStore();
        InjectMaid injectMaid = new InjectMaid(definitions, defaultSingletonType, singletonStore, scope, scopeManager, interceptors, lifecycleManager);
        injectMaid.loadEagerSingletons();
        return injectMaid;
    }

    public void initializeAllSingletons() {
        this.definitions.definitionsOnScope(this.scope).stream().filter(Definition::isSingleton).forEach(this::internalGetInstance);
    }

    private void loadEagerSingletons() {
        this.definitions.definitionsOnScope(this.scope).stream().filter(this::isEagerSingleton).forEach(this::internalGetInstance);
    }

    private boolean isEagerSingleton(Definition definition) {
        ReusePolicy reusePolicy = definition.reusePolicy();
        if (reusePolicy == ReusePolicy.SINGLETON) {
            return this.defaultSingletonType == SingletonType.EAGER;
        }
        return reusePolicy == ReusePolicy.EAGER_SINGLETON;
    }

    public InjectMaid enterScope(ResolvedType resolvedType, Object scopeObject) {
        Scope childScope = this.scope.childScope(resolvedType);
        List<Scope> scopes = this.definitions.allScopes();
        if (!scopes.contains(childScope)) {
            String registeredScopes = scopes.stream().map(Scope::render).sorted().collect(Collectors.joining(", ", "[", "]"));
            throw InjectMaidException.injectMaidException(String.format("Tried to enter unknown scope '%s' with object '%s'. Registered scopes: %s", childScope.render(), scopeObject, registeredScopes));
        }
        SingletonStore childSingletonStore = this.singletonStore.child(resolvedType);
        ScopeManager childScopeManager = this.scopeManager.add(resolvedType, scopeObject);
        Interceptors childInterceptors = this.interceptors.enterScope(resolvedType, scopeObject);
        InjectMaid scopedInjectMaid = new InjectMaid(this.definitions, this.defaultSingletonType, childSingletonStore, childScope, childScopeManager, childInterceptors, this.lifecycleManager.newInstance());
        this.children.add(scopedInjectMaid);
        return scopedInjectMaid;
    }

    public void addInterceptor(SimpleInterceptor interceptor) {
        this.interceptors.addInterceptor((Interceptor)interceptor);
    }

    public void overwriteWith(Injector injector) {
        OverwritingInterceptor interceptor = OverwritingInterceptor.overwritingInterceptor(injector);
        this.interceptors.addInterceptor(interceptor);
    }

    public Object getInstance(ResolvedType type) {
        Optional<?> intercepted = this.interceptors.interceptBefore(type);
        if (intercepted.isPresent()) {
            return intercepted.get();
        }
        Definition definition = this.definitions.definitionFor(type, this.scope);
        Object instance = this.internalGetInstance(definition);
        Object interceptedInstance = this.interceptors.interceptAfter(type, instance);
        this.lifecycleManager.registerInstance(interceptedInstance);
        return interceptedInstance;
    }

    public boolean canInstantiate(ResolvedType resolvedType) {
        return this.definitions.hasDefinitionFor(resolvedType, this.scope);
    }

    public String debugInformation() {
        return this.definitions.dump();
    }

    private Object internalGetInstance(Definition definition) {
        return this.createAndRegister(definition, () -> this.instantiate(definition));
    }

    private Object instantiate(Definition definition) {
        Instantiator instantiator = definition.instantiator();
        List<Object> dependencies = this.instantiateDependencies(instantiator);
        try {
            return instantiator.instantiate(dependencies, this.scopeManager, this);
        }
        catch (Exception e) {
            throw InjectMaidException.injectMaidException(String.format("Exception during instantiation of '%s' using %s", definition.type().simpleDescription(), instantiator.description()), e);
        }
    }

    private List<Object> instantiateDependencies(Instantiator instantiator) {
        return instantiator.dependencies().stream().map(this::getInstance).collect(Collectors.toList());
    }

    private Object createAndRegister(Definition definition, Supplier<Object> instantiator) {
        boolean singleton = definition.isSingleton();
        ResolvedType type = definition.type();
        Scope definitionScope = definition.scope();
        if (singleton && this.singletonStore.contains(type, definitionScope)) {
            return this.singletonStore.get(type, definitionScope);
        }
        Object instance = instantiator.get();
        if (singleton) {
            this.singletonStore.put(type, definitionScope, instance);
        }
        return instance;
    }

    public void close() {
        ArrayList<ExceptionDuringClose> exceptions = new ArrayList<ExceptionDuringClose>();
        this.close(exceptions);
        if (!exceptions.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner("\n", "exception(s) during close:\n", "");
            exceptions.forEach(exceptionDuringClose -> stringJoiner.add(exceptionDuringClose.buildMessage()));
            InjectMaidException exception = InjectMaidException.injectMaidException(stringJoiner.toString());
            exceptions.forEach(exceptionDuringClose -> exception.addSuppressed(exceptionDuringClose.exception()));
            throw exception;
        }
    }

    private void close(List<ExceptionDuringClose> exceptions) {
        this.children.forEach(injectMaid -> injectMaid.close(exceptions));
        this.lifecycleManager.closeAll(exceptions);
    }

    @Generated
    public String toString() {
        return "InjectMaid(definitions=" + this.definitions + ", defaultSingletonType=" + this.defaultSingletonType + ", singletonStore=" + this.singletonStore + ", scope=" + this.scope + ", scopeManager=" + this.scopeManager + ", interceptors=" + this.interceptors + ", children=" + this.children + ", lifecycleManager=" + this.lifecycleManager + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InjectMaid)) {
            return false;
        }
        InjectMaid other = (InjectMaid)o;
        Definitions this$definitions = this.definitions;
        Definitions other$definitions = other.definitions;
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        SingletonType this$defaultSingletonType = this.defaultSingletonType;
        SingletonType other$defaultSingletonType = other.defaultSingletonType;
        if (this$defaultSingletonType == null ? other$defaultSingletonType != null : !this$defaultSingletonType.equals(other$defaultSingletonType)) {
            return false;
        }
        SingletonStore this$singletonStore = this.singletonStore;
        SingletonStore other$singletonStore = other.singletonStore;
        if (this$singletonStore == null ? other$singletonStore != null : !((Object)this$singletonStore).equals(other$singletonStore)) {
            return false;
        }
        Scope this$scope = this.scope;
        Scope other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        ScopeManager this$scopeManager = this.scopeManager;
        ScopeManager other$scopeManager = other.scopeManager;
        if (this$scopeManager == null ? other$scopeManager != null : !((Object)this$scopeManager).equals(other$scopeManager)) {
            return false;
        }
        Interceptors this$interceptors = this.interceptors;
        Interceptors other$interceptors = other.interceptors;
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        List<InjectMaid> this$children = this.children;
        List<InjectMaid> other$children = other.children;
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        LifecycleManager this$lifecycleManager = this.lifecycleManager;
        LifecycleManager other$lifecycleManager = other.lifecycleManager;
        return !(this$lifecycleManager == null ? other$lifecycleManager != null : !this$lifecycleManager.equals(other$lifecycleManager));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Definitions $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        SingletonType $defaultSingletonType = this.defaultSingletonType;
        result = result * 59 + ($defaultSingletonType == null ? 43 : $defaultSingletonType.hashCode());
        SingletonStore $singletonStore = this.singletonStore;
        result = result * 59 + ($singletonStore == null ? 43 : ((Object)$singletonStore).hashCode());
        Scope $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        ScopeManager $scopeManager = this.scopeManager;
        result = result * 59 + ($scopeManager == null ? 43 : ((Object)$scopeManager).hashCode());
        Interceptors $interceptors = this.interceptors;
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        List<InjectMaid> $children = this.children;
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        LifecycleManager $lifecycleManager = this.lifecycleManager;
        result = result * 59 + ($lifecycleManager == null ? 43 : $lifecycleManager.hashCode());
        return result;
    }

    @Generated
    private InjectMaid(Definitions definitions, SingletonType defaultSingletonType, SingletonStore singletonStore, Scope scope, ScopeManager scopeManager, Interceptors interceptors, LifecycleManager lifecycleManager) {
        this.definitions = definitions;
        this.defaultSingletonType = defaultSingletonType;
        this.singletonStore = singletonStore;
        this.scope = scope;
        this.scopeManager = scopeManager;
        this.interceptors = interceptors;
        this.lifecycleManager = lifecycleManager;
    }
}

