/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.servlet;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.endpoint.RawRequestBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ServletHandling {
    private ServletHandling() {
    }

    public static void handle(HttpMaid httpMaid, HttpServletRequest request, HttpServletResponse response) {
        httpMaid.handleRequest(() -> {
            RawRequestBuilder builder = ServletHandling.extractMetaDataFromHttpServletRequest(request);
            ServletInputStream body = request.getInputStream();
            builder.withBody((InputStream)body);
            return builder.build();
        }, rawResponse -> {
            rawResponse.setHeaders((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            int responseStatus = rawResponse.status();
            response.setStatus(responseStatus);
            ServletOutputStream outputStream = response.getOutputStream();
            rawResponse.streamBodyToOutputStream((OutputStream)outputStream);
        });
    }

    public static RawRequestBuilder extractMetaDataFromHttpServletRequest(HttpServletRequest request) {
        RawRequestBuilder builder = RawRequest.rawRequestBuilder();
        String path = request.getPathInfo();
        builder.withPath(path);
        String method = request.getMethod();
        builder.withMethod(method);
        Map<String, List<String>> headers = ServletHandling.extractHeaders(request);
        builder.withHeaders(headers);
        Map<String, String> queryParameters = ServletHandling.extractQueryParameters(request);
        builder.withQueryParameters(queryParameters);
        return builder;
    }

    private static Map<String, List<String>> extractHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String value = request.getHeader(headerName);
            headers.put(headerName, Collections.singletonList(value));
        }
        return headers;
    }

    private static Map<String, String> extractQueryParameters(HttpServletRequest request) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String value = request.getParameter(parameterName);
            queryParameters.put(parameterName, value);
        }
        return queryParameters;
    }
}

