/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.servlet;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ServletHandling {
    private ServletHandling() {
    }

    public static void handle(HttpMaid httpMaid, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MetaData metaData = ServletHandling.extractMetaDataFromHttpServletRequest(request);
        ServletInputStream body = request.getInputStream();
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STREAM, (Object)body);
        metaData.set(HttpMaidChainKeys.IS_HTTP_REQUEST, (Object)true);
        httpMaid.handleRequest(metaData, httpResponse -> {
            Map responseHeaders = (Map)metaData.get(HttpMaidChainKeys.RESPONSE_HEADERS);
            responseHeaders.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            int responseStatus = (Integer)metaData.get(HttpMaidChainKeys.RESPONSE_STATUS);
            response.setStatus(responseStatus);
            ServletOutputStream outputStream = response.getOutputStream();
            InputStream responseBody = metaData.getOptional(HttpMaidChainKeys.RESPONSE_STREAM).orElseGet(() -> Streams.stringToInputStream((String)""));
            Streams.streamInputStreamToOutputStream((InputStream)responseBody, (OutputStream)outputStream);
        });
    }

    public static MetaData extractMetaDataFromHttpServletRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        String method = request.getMethod();
        Map<String, List<String>> headers = ServletHandling.extractHeaders(request);
        Map<String, String> queryParameters = ServletHandling.extractQueryParameters(request);
        MetaData metaData = MetaData.emptyMetaData();
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_HEADERS, headers);
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_QUERY_PARAMETERS, queryParameters);
        metaData.set(HttpMaidChainKeys.RAW_METHOD, (Object)method);
        metaData.set(HttpMaidChainKeys.RAW_PATH, (Object)path);
        return metaData;
    }

    private static Map<String, List<String>> extractHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String value = request.getHeader(headerName);
            headers.put(headerName, Collections.singletonList(value));
        }
        return headers;
    }

    private static Map<String, String> extractQueryParameters(HttpServletRequest request) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String value = request.getParameter(parameterName);
            queryParameters.put(parameterName, value);
        }
        return queryParameters;
    }
}

