/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.servlet;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.endpoint.RawHttpRequest;
import de.quantummaid.httpmaid.endpoint.RawHttpRequestBuilder;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.HeadersBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Optional;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ServletHandling {
    private ServletHandling() {
    }

    public static void handle(HttpMaid httpMaid, HttpServletRequest request, HttpServletResponse response) {
        httpMaid.handleRequest(() -> {
            RawHttpRequestBuilder builder = ServletHandling.extractMetaDataFromHttpServletRequest(request);
            ServletInputStream body = request.getInputStream();
            builder.withBody((InputStream)body);
            return builder.build();
        }, rawResponse -> {
            rawResponse.setHeaders((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
            int responseStatus = rawResponse.status();
            response.setStatus(responseStatus);
            ServletOutputStream outputStream = response.getOutputStream();
            rawResponse.streamBodyToOutputStream((OutputStream)outputStream);
        });
    }

    public static RawHttpRequestBuilder extractMetaDataFromHttpServletRequest(HttpServletRequest request) {
        RawHttpRequestBuilder builder = RawHttpRequest.rawHttpRequestBuilder();
        String path = request.getPathInfo();
        builder.withPath(path);
        String method = request.getMethod();
        builder.withMethod(method);
        Headers headers = ServletHandling.extractHeaders(request);
        builder.withHeaders(headers);
        String queryString = Optional.ofNullable(request.getQueryString()).orElse("");
        builder.withQueryString(queryString);
        return builder;
    }

    private static Headers extractHeaders(HttpServletRequest request) {
        HeadersBuilder headersBuilder = HeadersBuilder.headersBuilder();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration values = request.getHeaders(headerName);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                headersBuilder.withAdditionalHeader(headerName, value);
            }
        }
        return headersBuilder.build();
    }
}

