/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.qcec.eventbus;

import de.quantummaid.eventmaid.messagebus.MessageBus;
import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.eventmaid.qcec.eventbus.EventBus;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.function.Consumer;
import lombok.Generated;

public class EventBusImpl
implements EventBus {
    private final MessageBus messageBus;

    @Override
    public void publish(Object event) {
        EventType eventType = EventType.eventTypeFromObjectClass(event);
        this.messageBus.send(eventType, event);
    }

    @Override
    public <T> SubscriptionId reactTo(Class<T> tClass, Consumer<T> consumer) {
        EventType eventType = EventType.eventTypeFromClass(tClass);
        return this.messageBus.subscribe(eventType, o -> {
            Object t = o;
            consumer.accept(t);
        });
    }

    @Override
    public void unsubscribe(SubscriptionId subscriptionId) {
        this.messageBus.unsubcribe(subscriptionId);
    }

    @Generated
    EventBusImpl(MessageBus messageBus) {
        this.messageBus = messageBus;
    }
}

