/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.collections.filtermap;

import de.quantummaid.eventmaid.internal.collections.filtermap.FilterMapEntry;
import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import java.util.List;
import lombok.Generated;

public final class FilterMap<F, G, T> {
    private final List<FilterMapEntry<F, G, T>> entries;
    private final T defaultValue;

    static <F, G, T> FilterMap<F, G, T> filterMap(List<FilterMapEntry<F, G, T>> entries, T defaultValue) {
        NotNullEnforcer.ensureNotNull(entries, "entries");
        NotNullEnforcer.ensureNotNull(defaultValue, "defaultValue");
        return new FilterMap<F, G, T>(entries, defaultValue);
    }

    public T get(F condition1, G condition2) {
        return (T)this.entries.stream().filter(entry -> entry.test(condition1, condition2)).map(FilterMapEntry::value).findFirst().orElse(this.defaultValue);
    }

    @Generated
    private FilterMap(List<FilterMapEntry<F, G, T>> entries, T defaultValue) {
        this.entries = entries;
        this.defaultValue = defaultValue;
    }
}

