/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.channel.action;

import de.quantummaid.eventmaid.channel.action.Action;
import de.quantummaid.eventmaid.processingcontext.ProcessingContext;
import de.quantummaid.eventmaid.subscribing.AcceptingBehavior;
import de.quantummaid.eventmaid.subscribing.ConsumerSubscriber;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Subscription<T>
implements Action<T> {
    private final List<Subscriber<ProcessingContext<T>>> subscribers = new CopyOnWriteArrayList<Subscriber<ProcessingContext<T>>>();

    public static <T> Subscription<T> subscription() {
        return new Subscription<T>();
    }

    public SubscriptionId addSubscriber(Consumer<T> consumer) {
        ConsumerSubscriber<T> subscriber = ConsumerSubscriber.consumerSubscriber(consumer);
        return this.addSubscriber(subscriber);
    }

    public SubscriptionId addSubscriber(Subscriber<T> subscriber) {
        return this.addRawSubscriber(new WrappingRawSubscriber(subscriber));
    }

    public SubscriptionId addRawSubscriber(Consumer<ProcessingContext<T>> consumer) {
        ConsumerSubscriber<ProcessingContext<T>> subscriber = ConsumerSubscriber.consumerSubscriber(consumer);
        return this.addRawSubscriber(subscriber);
    }

    public SubscriptionId addRawSubscriber(Subscriber<ProcessingContext<T>> subscriber) {
        this.subscribers.add(subscriber);
        return subscriber.getSubscriptionId();
    }

    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    public List<Subscriber<?>> getAllSubscribers() {
        return this.subscribers.stream().map(s -> {
            if (s.getClass().equals(WrappingRawSubscriber.class)) {
                return ((WrappingRawSubscriber)s).subscriber;
            }
            return s;
        }).collect(Collectors.toList());
    }

    List<Subscriber<ProcessingContext<T>>> getRealSubscribers() {
        return this.subscribers;
    }

    public void removeSubscriber(Subscriber<?> subscriber) {
        SubscriptionId subscriptionId = subscriber.getSubscriptionId();
        this.removeSubscriber(subscriptionId);
    }

    public void removeSubscriber(SubscriptionId subscriptionId) {
        this.subscribers.removeIf(subscriber -> subscriber.getSubscriptionId().equals(subscriptionId));
    }

    @Generated
    private Subscription() {
    }

    private final class WrappingRawSubscriber
    implements Subscriber<ProcessingContext<T>> {
        private final Subscriber<T> subscriber;

        private WrappingRawSubscriber(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public AcceptingBehavior accept(ProcessingContext<T> message) {
            Object payload = message.getPayload();
            return this.subscriber.accept(payload);
        }

        @Override
        public SubscriptionId getSubscriptionId() {
            return this.subscriber.getSubscriptionId();
        }
    }
}

