/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messagefunction.internal;

import de.quantummaid.eventmaid.messagefunction.ResponseFuture;
import de.quantummaid.eventmaid.messagefunction.followup.FollowUpAction;
import de.quantummaid.eventmaid.messagefunction.internal.SubscriptionContainer;
import de.quantummaid.eventmaid.processingcontext.ProcessingContext;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;

public final class ExpectedResponseFuture
implements ResponseFuture {
    private final SubscriptionContainer subscriptionContainer;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final AtomicReference<ProcessingContext<Object>> responseRef = new AtomicReference<Object>(null);
    private final AtomicReference<FollowUpAction> followUpActionRef = new AtomicReference<Object>(null);
    private final AtomicReference<Exception> thrownExceptionRef = new AtomicReference<Object>(null);
    private volatile boolean isCancelled;
    private volatile boolean successful;

    public static ExpectedResponseFuture expectedResponseFuture(SubscriptionContainer subscriptionContainer) {
        return new ExpectedResponseFuture(subscriptionContainer);
    }

    public synchronized void fullFill(ProcessingContext<Object> response) {
        if (!this.isCancelled()) {
            Object errorPayload = response.getErrorPayload();
            this.successful = errorPayload == null;
            this.responseRef.set(response);
            this.finishFuture();
            FollowUpAction followUpAction = this.followUpActionRef.get();
            if (followUpAction != null) {
                Object payload = response.getPayload();
                followUpAction.apply(payload, errorPayload, null);
            }
        }
    }

    public synchronized void fullFillWithException(Exception e) {
        if (!this.isCancelled()) {
            this.thrownExceptionRef.set(e);
            this.successful = false;
            this.finishFuture();
            FollowUpAction followUpAction = this.followUpActionRef.get();
            if (followUpAction != null) {
                followUpAction.apply(null, null, e);
            }
        }
    }

    private void finishFuture() {
        this.countDownLatch.countDown();
        this.subscriptionContainer.unsubscribe();
    }

    @Override
    public boolean wasSuccessful() {
        return !this.isCancelled && this.successful;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.isDone()) {
            this.isCancelled = true;
        }
        this.finishFuture();
        return !this.alreadyCompleted();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return this.alreadyCompleted() || this.isCancelled() || this.hasExceptionInExecution();
    }

    private boolean alreadyCompleted() {
        return this.responseRef.get() != null;
    }

    private boolean hasExceptionInExecution() {
        return this.thrownExceptionRef.get() != null;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        return this.getResponseRef(() -> this.responseRef.get().getPayload());
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getResponseRef(() -> this.responseRef.get().getPayload(), timeout, unit);
    }

    @Override
    public Object getErrorResponse() throws InterruptedException, ExecutionException {
        return this.getResponseRef(() -> this.responseRef.get().getErrorPayload());
    }

    @Override
    public Object getErrorResponse(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getResponseRef(() -> this.responseRef.get().getErrorPayload(), timeout, unit);
    }

    @Override
    public ProcessingContext<Object> getRaw() throws InterruptedException, ExecutionException {
        return this.getResponseRef(this.responseRef::get);
    }

    @Override
    public ProcessingContext<Object> getRaw(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getResponseRef(this.responseRef::get, timeout, unit);
    }

    private <T> T getResponseRef(Supplier<T> responseSupplier) throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            this.countDownLatch.await();
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
        }
        if (this.hasExceptionInExecution()) {
            throw new ExecutionException(this.thrownExceptionRef.get());
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        return responseSupplier.get();
    }

    private <T> T getResponseRef(Supplier<T> responseSupplier, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.isDone()) {
            if (!this.countDownLatch.await(timeout, unit)) {
                throw new TimeoutException("Response future timed out");
            }
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (this.hasExceptionInExecution()) {
            throw new ExecutionException(this.thrownExceptionRef.get());
        }
        return responseSupplier.get();
    }

    @Override
    public synchronized void then(FollowUpAction followUpAction) {
        if (this.followUpActionRef.get() != null) {
            throw new UnsupportedOperationException("Then can only be called once.");
        }
        this.followUpActionRef.set(followUpAction);
        if (this.isDone()) {
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            ProcessingContext<Object> currentResponse = this.responseRef.get();
            if (currentResponse != null) {
                Object payload = currentResponse.getPayload();
                Object errorPayload = currentResponse.getErrorPayload();
                followUpAction.apply(payload, errorPayload, null);
            } else {
                followUpAction.apply(null, null, this.thrownExceptionRef.get());
            }
        }
    }

    @Generated
    private ExpectedResponseFuture(SubscriptionContainer subscriptionContainer) {
        this.subscriptionContainer = subscriptionContainer;
    }
}

