/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messagebus;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.ChannelBuilder;
import de.quantummaid.eventmaid.channel.ChannelType;
import de.quantummaid.eventmaid.configuration.AsynchronousConfiguration;
import de.quantummaid.eventmaid.messagebus.MessageBus;
import de.quantummaid.eventmaid.messagebus.MessageBusConsumeAction;
import de.quantummaid.eventmaid.messagebus.MessageBusImpl;
import de.quantummaid.eventmaid.messagebus.MessageBusType;
import de.quantummaid.eventmaid.messagebus.channelcreating.MessageBusChannelFactory;
import de.quantummaid.eventmaid.messagebus.channelcreating.SynchronousMessageBusChannelFactory;
import de.quantummaid.eventmaid.messagebus.exception.ErrorThrowingMessageBusExceptionHandler;
import de.quantummaid.eventmaid.messagebus.exception.MessageBusExceptionHandler;
import de.quantummaid.eventmaid.messagebus.internal.brokering.MessageBusBrokerStrategy;
import de.quantummaid.eventmaid.messagebus.internal.brokering.MessageBusBrokerStrategyImpl;
import de.quantummaid.eventmaid.messagebus.internal.correlationids.CorrelationBasedSubscriptions;
import de.quantummaid.eventmaid.messagebus.internal.correlationids.CorrelationBasedSubscriptionsImpl;
import de.quantummaid.eventmaid.messagebus.internal.exception.DelegatingChannelExceptionHandler;
import de.quantummaid.eventmaid.messagebus.internal.exception.ErrorListenerDelegatingMessageBusExceptionHandler;
import de.quantummaid.eventmaid.messagebus.internal.exception.ExceptionListenerHandlerImpl;
import java.util.Objects;
import lombok.Generated;

public final class MessageBusBuilder {
    private MessageBusChannelFactory channelFactory;
    private MessageBusType type = MessageBusType.SYNCHRONOUS;
    private AsynchronousConfiguration asynchronousConfiguration;
    private MessageBusExceptionHandler exceptionHandler = ErrorThrowingMessageBusExceptionHandler.errorThrowingMessageBusExceptionHandler();

    public static MessageBusBuilder aMessageBus() {
        return new MessageBusBuilder();
    }

    public MessageBusBuilder forType(MessageBusType type) {
        this.type = type;
        return this;
    }

    public MessageBusBuilder withAChannelFactory(MessageBusChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public MessageBusBuilder withAsynchronousConfiguration(AsynchronousConfiguration asynchronousConfiguration) {
        this.asynchronousConfiguration = asynchronousConfiguration;
        return this;
    }

    public MessageBusBuilder withExceptionHandler(MessageBusExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public MessageBus build() {
        ExceptionListenerHandlerImpl errorListenerHandler = ExceptionListenerHandlerImpl.errorListenerHandler();
        MessageBusExceptionHandler actualExceptionHandler = this.createExceptionHandler(errorListenerHandler);
        MessageBusBrokerStrategy brokerStrategy = this.createBrokerStrategy(actualExceptionHandler);
        CorrelationBasedSubscriptionsImpl correlationBasedSubscriptions = CorrelationBasedSubscriptionsImpl.correlationBasedSubscriptions();
        Channel<Object> acceptingChannel = null;
        try {
            acceptingChannel = this.createAcceptingChannel(brokerStrategy, actualExceptionHandler, correlationBasedSubscriptions);
            return new MessageBusImpl(acceptingChannel, brokerStrategy, correlationBasedSubscriptions, errorListenerHandler);
        }
        catch (RuntimeException e) {
            if (acceptingChannel != null) {
                acceptingChannel.close();
            }
            throw e;
        }
    }

    private MessageBusBrokerStrategy createBrokerStrategy(MessageBusExceptionHandler exceptionHandler) {
        MessageBusChannelFactory createdChannelFactory = this.createChannelFactory();
        return MessageBusBrokerStrategyImpl.messageBusBrokerStrategyImpl(createdChannelFactory, exceptionHandler);
    }

    private MessageBusExceptionHandler createExceptionHandler(ExceptionListenerHandlerImpl errorListenerHandler) {
        return ErrorListenerDelegatingMessageBusExceptionHandler.errorListenerDelegatingMessageBusExceptionHandler(this.exceptionHandler, errorListenerHandler);
    }

    private MessageBusChannelFactory createChannelFactory() {
        return Objects.requireNonNullElseGet(this.channelFactory, SynchronousMessageBusChannelFactory::synchronousMessageBusChannelFactory);
    }

    private Channel<Object> createAcceptingChannel(MessageBusBrokerStrategy brokerStrategy, MessageBusExceptionHandler exceptionHandler, CorrelationBasedSubscriptions correlationBasedSubscriptions) {
        ChannelType channelType = this.map(this.type);
        DelegatingChannelExceptionHandler acceptingPipeExceptionHandler = DelegatingChannelExceptionHandler.delegatingChannelExceptionHandlerForAcceptingChannel(exceptionHandler);
        Channel<Object> acceptingChannel = ChannelBuilder.aChannel().forType(channelType).withAsynchronousConfiguration(this.asynchronousConfiguration).withChannelExceptionHandler(acceptingPipeExceptionHandler).withDefaultAction(MessageBusConsumeAction.messageBusConsumeAction(brokerStrategy, correlationBasedSubscriptions)).build();
        acceptingPipeExceptionHandler.setChannel(acceptingChannel);
        return acceptingChannel;
    }

    private ChannelType map(MessageBusType messageBusType) {
        switch (messageBusType) {
            case SYNCHRONOUS: {
                return ChannelType.SYNCHRONOUS;
            }
            case ASYNCHRONOUS: {
                return ChannelType.ASYNCHRONOUS;
            }
        }
        throw new IllegalArgumentException("Unknown type for message bus: " + messageBusType);
    }

    @Generated
    private MessageBusBuilder() {
    }
}

