/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.collections.filtermap;

import de.quantummaid.eventmaid.internal.collections.filtermap.FilterMap;
import de.quantummaid.eventmaid.internal.collections.filtermap.FilterMapEntry;
import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import lombok.Generated;

public final class FilterMapBuilder<F, G, T> {
    private final List<FilterMapEntry<F, G, T>> entries;
    private T defaultValue;

    public static <F, G, T> FilterMapBuilder<F, G, T> filterMapBuilder() {
        return new FilterMapBuilder<F, G, T>(new CopyOnWriteArrayList<FilterMapEntry<F, G, T>>());
    }

    public FilterMapBuilder<F, G, T> put(BiPredicate<F, G> filter, T value) {
        FilterMapEntry<F, G, T> entry = FilterMapEntry.filterMapEntry(filter, value);
        this.entries.add(entry);
        return this;
    }

    public void setDefaultValue(T defaultValue) {
        NotNullEnforcer.ensureNotNull(defaultValue, "defaultValue");
        this.defaultValue = defaultValue;
    }

    public FilterMap<F, G, T> build() {
        return FilterMap.filterMap(this.entries, this.defaultValue);
    }

    @Generated
    private FilterMapBuilder(List<FilterMapEntry<F, G, T>> entries) {
        this.entries = entries;
    }
}

