/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.subscribing;

import de.quantummaid.eventmaid.subscribing.AcceptingBehavior;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.function.Predicate;
import lombok.Generated;

public final class PreemptiveSubscriber<T>
implements Subscriber<T> {
    private final Predicate<T> predicate;
    private final SubscriptionId subscriptionId = SubscriptionId.newUniqueId();

    public static <T> PreemptiveSubscriber<T> preemptiveSubscriber(Predicate<T> predicate) {
        return new PreemptiveSubscriber<T>(predicate);
    }

    @Override
    public AcceptingBehavior accept(T message) {
        boolean continueDelivery = this.predicate.test(message);
        return AcceptingBehavior.acceptingBehavior(continueDelivery);
    }

    @Override
    public SubscriptionId getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public String toString() {
        return "PreemptiveSubscriber(predicate=" + this.predicate + ", subscriptionId=" + this.getSubscriptionId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreemptiveSubscriber)) {
            return false;
        }
        PreemptiveSubscriber other = (PreemptiveSubscriber)o;
        Predicate<T> this$predicate = this.predicate;
        Predicate<T> other$predicate = other.predicate;
        if (this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate)) {
            return false;
        }
        SubscriptionId this$subscriptionId = this.getSubscriptionId();
        SubscriptionId other$subscriptionId = other.getSubscriptionId();
        return !(this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Predicate<T> $predicate = this.predicate;
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        SubscriptionId $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        return result;
    }

    @Generated
    private PreemptiveSubscriber(Predicate<T> predicate) {
        this.predicate = predicate;
    }
}

