/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.processingcontext;

import de.quantummaid.eventmaid.channel.ChannelProcessingFrame;
import de.quantummaid.eventmaid.channel.action.Action;
import de.quantummaid.eventmaid.identification.CorrelationId;
import de.quantummaid.eventmaid.identification.MessageId;
import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import de.quantummaid.eventmaid.processingcontext.EventType;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public final class ProcessingContext<T> {
    private final EventType eventType;
    private final MessageId messageId;
    private final Map<Object, Object> contextMetaData;
    private CorrelationId correlationId;
    private T payload;
    private Object errorPayload;
    private ChannelProcessingFrame<T> initialProcessingFrame;
    private ChannelProcessingFrame<T> currentProcessingFrame;

    private ProcessingContext(EventType eventType, MessageId messageId, CorrelationId correlationId, T payload, Object errorPayload, Map<Object, Object> contextMetaData, ChannelProcessingFrame<T> initialProcessingFrame, ChannelProcessingFrame<T> currentProcessingFrame) {
        NotNullEnforcer.ensureNotNull(eventType, "eventType");
        this.eventType = eventType;
        NotNullEnforcer.ensureNotNull(messageId, "messageId");
        this.messageId = messageId;
        this.correlationId = correlationId;
        NotNullEnforcer.ensureNotNull(contextMetaData, "contextMetaData");
        this.contextMetaData = contextMetaData;
        this.payload = payload;
        this.errorPayload = errorPayload;
        this.initialProcessingFrame = initialProcessingFrame;
        this.currentProcessingFrame = currentProcessingFrame;
    }

    public static <T> ProcessingContext<T> processingContext(EventType eventType, T payload) {
        HashMap<Object, Object> contextMetaData = new HashMap<Object, Object>();
        MessageId messageId = MessageId.newUniqueMessageId();
        return new ProcessingContext<T>(eventType, messageId, null, payload, null, contextMetaData, null, null);
    }

    public static <T> ProcessingContext<T> processingContext(EventType eventType, MessageId messageId, T payload) {
        HashMap<Object, Object> contextMetaData = new HashMap<Object, Object>();
        return new ProcessingContext<T>(eventType, messageId, null, payload, null, contextMetaData, null, null);
    }

    public static <T> ProcessingContext<T> processingContext(EventType eventType, T payload, CorrelationId correlationId) {
        HashMap<Object, Object> metaData = new HashMap<Object, Object>();
        MessageId messageId = MessageId.newUniqueMessageId();
        return new ProcessingContext<T>(eventType, messageId, correlationId, payload, null, metaData, null, null);
    }

    public static <T> ProcessingContext<T> processingContext(EventType eventType, MessageId messageId, CorrelationId correlationId, T payload, Object errorPayload) {
        HashMap<Object, Object> metaData = new HashMap<Object, Object>();
        return new ProcessingContext<T>(eventType, messageId, correlationId, payload, errorPayload, metaData, null, null);
    }

    public static <T> ProcessingContext<T> processingContext(EventType eventType, MessageId messageId, CorrelationId correlationId, T payload, Object errorPayload, Map<Object, Object> contextMetaData, ChannelProcessingFrame<T> initialProcessingFrame, ChannelProcessingFrame<T> currentProcessingFrame) {
        return new ProcessingContext<T>(eventType, messageId, correlationId, payload, errorPayload, contextMetaData, initialProcessingFrame, currentProcessingFrame);
    }

    public static <T> ProcessingContext<T> processingContextForError(EventType eventType, Object errorPayload) {
        HashMap<Object, Object> contextMetaData = new HashMap<Object, Object>();
        MessageId messageId = MessageId.newUniqueMessageId();
        return new ProcessingContext<Object>(eventType, messageId, null, null, errorPayload, contextMetaData, null, null);
    }

    public static <T> ProcessingContext<T> processingContextForPayloadAndError(EventType eventType, T payload, Object errorPayload) {
        HashMap<Object, Object> contextMetaData = new HashMap<Object, Object>();
        MessageId messageId = MessageId.newUniqueMessageId();
        return new ProcessingContext<T>(eventType, messageId, null, payload, errorPayload, contextMetaData, null, null);
    }

    public static <T> ProcessingContext<T> processingContextForPayloadAndError(EventType eventType, CorrelationId correlationId, T payload, Object errorPayload) {
        HashMap<Object, Object> contextMetaData = new HashMap<Object, Object>();
        MessageId messageId = MessageId.newUniqueMessageId();
        return new ProcessingContext<T>(eventType, messageId, correlationId, payload, errorPayload, contextMetaData, null, null);
    }

    public boolean actionWasChanged() {
        return this.currentProcessingFrame.getAction() != null;
    }

    public Action<T> getAction() {
        return this.currentProcessingFrame.getAction();
    }

    public void changeAction(Action<T> action) {
        this.currentProcessingFrame.setAction(action);
    }

    public CorrelationId generateCorrelationIdForAnswer() {
        return CorrelationId.correlationIdFor(this.messageId);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public Map<Object, Object> getContextMetaData() {
        return this.contextMetaData;
    }

    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(CorrelationId correlationId) {
        this.correlationId = correlationId;
    }

    public T getPayload() {
        return this.payload;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public Object getErrorPayload() {
        return this.errorPayload;
    }

    public void setErrorPayload(Object errorPayload) {
        this.errorPayload = errorPayload;
    }

    public ChannelProcessingFrame<T> getInitialProcessingFrame() {
        return this.initialProcessingFrame;
    }

    public void setInitialProcessingFrame(ChannelProcessingFrame<T> initialProcessingFrame) {
        this.initialProcessingFrame = initialProcessingFrame;
    }

    public ChannelProcessingFrame<T> getCurrentProcessingFrame() {
        return this.currentProcessingFrame;
    }

    public void setCurrentProcessingFrame(ChannelProcessingFrame<T> currentProcessingFrame) {
        this.currentProcessingFrame = currentProcessingFrame;
    }

    @Generated
    public String toString() {
        return "ProcessingContext(eventType=" + this.getEventType() + ", messageId=" + this.getMessageId() + ", contextMetaData=" + this.getContextMetaData() + ", correlationId=" + this.getCorrelationId() + ", payload=" + this.getPayload() + ", errorPayload=" + this.getErrorPayload() + ", initialProcessingFrame=" + this.getInitialProcessingFrame() + ", currentProcessingFrame=" + this.getCurrentProcessingFrame() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessingContext)) {
            return false;
        }
        ProcessingContext other = (ProcessingContext)o;
        EventType this$eventType = this.getEventType();
        EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)this$eventType).equals(other$eventType)) {
            return false;
        }
        MessageId this$messageId = this.getMessageId();
        MessageId other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Map<Object, Object> this$contextMetaData = this.getContextMetaData();
        Map<Object, Object> other$contextMetaData = other.getContextMetaData();
        if (this$contextMetaData == null ? other$contextMetaData != null : !((Object)this$contextMetaData).equals(other$contextMetaData)) {
            return false;
        }
        CorrelationId this$correlationId = this.getCorrelationId();
        CorrelationId other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !((Object)this$correlationId).equals(other$correlationId)) {
            return false;
        }
        T this$payload = this.getPayload();
        T other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        Object this$errorPayload = this.getErrorPayload();
        Object other$errorPayload = other.getErrorPayload();
        if (this$errorPayload == null ? other$errorPayload != null : !this$errorPayload.equals(other$errorPayload)) {
            return false;
        }
        ChannelProcessingFrame<T> this$initialProcessingFrame = this.getInitialProcessingFrame();
        ChannelProcessingFrame<T> other$initialProcessingFrame = other.getInitialProcessingFrame();
        if (this$initialProcessingFrame == null ? other$initialProcessingFrame != null : !this$initialProcessingFrame.equals(other$initialProcessingFrame)) {
            return false;
        }
        ChannelProcessingFrame<T> this$currentProcessingFrame = this.getCurrentProcessingFrame();
        ChannelProcessingFrame<T> other$currentProcessingFrame = other.getCurrentProcessingFrame();
        return !(this$currentProcessingFrame == null ? other$currentProcessingFrame != null : !this$currentProcessingFrame.equals(other$currentProcessingFrame));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)$eventType).hashCode());
        MessageId $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Map<Object, Object> $contextMetaData = this.getContextMetaData();
        result = result * 59 + ($contextMetaData == null ? 43 : ((Object)$contextMetaData).hashCode());
        CorrelationId $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : ((Object)$correlationId).hashCode());
        T $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        Object $errorPayload = this.getErrorPayload();
        result = result * 59 + ($errorPayload == null ? 43 : $errorPayload.hashCode());
        ChannelProcessingFrame<T> $initialProcessingFrame = this.getInitialProcessingFrame();
        result = result * 59 + ($initialProcessingFrame == null ? 43 : $initialProcessingFrame.hashCode());
        ChannelProcessingFrame<T> $currentProcessingFrame = this.getCurrentProcessingFrame();
        result = result * 59 + ($currentProcessingFrame == null ? 43 : $currentProcessingFrame.hashCode());
        return result;
    }
}

