/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.qcec.domainBus.internal.answer;

import de.quantummaid.eventmaid.qcec.domainBus.building.AnswerStep1Builder;
import de.quantummaid.eventmaid.qcec.domainBus.building.AnswerStep2Builder;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.Answer;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.AnswerRegister;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.ConstraintAnswerImpl;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.EventAnswerImpl;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.QueryAnswerImpl;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.TerminationCondition;
import de.quantummaid.eventmaid.qcec.queryresolving.Query;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;

public final class AnswerBuilder<T>
implements AnswerStep1Builder<T>,
AnswerStep2Builder<T> {
    private final List<Predicate<T>> onlyIfConditions = new ArrayList<Predicate<T>>();
    private final List<TerminationCondition<?>> terminationConditions = new ArrayList();
    private final AnswerCreation<T> answerCreation;
    private final AnswerRegister answerRegister;

    public static <T extends Query<?>> AnswerStep1Builder<T> anQueryAnswerForClass(Class<T> queryClass, AnswerRegister answerRegister) {
        AnswerCreation answerCreation = (responseCondition, responseConsumer, terminationConditions) -> QueryAnswerImpl.queryAnswer(queryClass, responseCondition, responseConsumer, terminationConditions);
        return new AnswerBuilder(answerCreation, answerRegister);
    }

    public static <T> AnswerStep1Builder<T> anConstraintAnswerForClass(Class<T> constraintClass, AnswerRegister answerRegister) {
        AnswerCreation answerCreation = (responseCondition, responseConsumer, terminationConditions) -> ConstraintAnswerImpl.constraintAnswer(constraintClass, responseCondition, responseConsumer, terminationConditions);
        return new AnswerBuilder(answerCreation, answerRegister);
    }

    public static <T> AnswerStep1Builder<T> anEventAnswerForClass(Class<T> queryClass, AnswerRegister answerRegister) {
        AnswerCreation answerCreation = (responseCondition, responseConsumer, terminationConditions) -> EventAnswerImpl.eventAnswer(queryClass, responseCondition, responseConsumer, terminationConditions);
        return new AnswerBuilder(answerCreation, answerRegister);
    }

    @Override
    public AnswerStep1Builder<T> onlyIf(Predicate<T> condition) {
        this.onlyIfConditions.add(condition);
        return this;
    }

    @Override
    public AnswerStep2Builder<T> until(Class<?> eventClass) {
        return this.until(eventClass, o -> o.equals(eventClass));
    }

    @Override
    public <R> AnswerStep2Builder<T> until(Class<R> eventClass, Predicate<R> condition) {
        this.terminationConditions.add(TerminationCondition.terminationCondition(eventClass, condition));
        return this;
    }

    @Override
    public SubscriptionId using(Consumer<T> consumer) {
        Predicate<Object> combinedResponseCondition = t -> {
            if (this.onlyIfConditions.isEmpty()) {
                return true;
            }
            for (Predicate<Object> predicate : this.onlyIfConditions) {
                if (!predicate.test(t)) continue;
                return true;
            }
            return false;
        };
        return this.answerRegister.submit(this.answerCreation.create(combinedResponseCondition, consumer, this.terminationConditions));
    }

    @Generated
    private AnswerBuilder(AnswerCreation<T> answerCreation, AnswerRegister answerRegister) {
        this.answerCreation = answerCreation;
        this.answerRegister = answerRegister;
    }

    private static interface AnswerCreation<T> {
        public Answer create(Predicate<T> var1, Consumer<T> var2, List<TerminationCondition<?>> var3);
    }
}

