/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageFunction.internal;

import de.quantummaid.eventmaid.messageFunction.ResponseFuture;
import de.quantummaid.eventmaid.messageFunction.followup.FollowUpAction;
import de.quantummaid.eventmaid.messageFunction.internal.SubscriptionContainer;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import lombok.Generated;

public final class ExpectedResponseFuture
implements ResponseFuture {
    private final SubscriptionContainer subscriptionContainer;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private volatile boolean isCancelled;
    private volatile ProcessingContext<Object> response;
    private volatile boolean successful;
    private volatile FollowUpAction followUpAction;
    private volatile Exception thrownException;

    public static ExpectedResponseFuture expectedResponseFuture(SubscriptionContainer subscriptionContainer) {
        return new ExpectedResponseFuture(subscriptionContainer);
    }

    public synchronized void fullFill(ProcessingContext<Object> response) {
        if (!this.isCancelled()) {
            Object errorPayload = response.getErrorPayload();
            this.successful = errorPayload == null;
            this.response = response;
            this.finishFuture();
            if (this.followUpAction != null) {
                Object payload = response.getPayload();
                this.followUpAction.apply(payload, errorPayload, null);
            }
        }
    }

    public synchronized void fullFillWithException(Exception e) {
        if (!this.isCancelled()) {
            this.thrownException = e;
            this.successful = false;
            this.finishFuture();
            if (this.followUpAction != null) {
                this.followUpAction.apply(null, null, e);
            }
        }
    }

    private void finishFuture() {
        this.countDownLatch.countDown();
        this.subscriptionContainer.unsubscribe();
    }

    @Override
    public boolean wasSuccessful() {
        return !this.isCancelled && this.successful;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.isDone()) {
            this.isCancelled = true;
        }
        this.finishFuture();
        return !this.alreadyCompleted();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return this.alreadyCompleted() || this.isCancelled() || this.hasExceptionInExecution();
    }

    private boolean alreadyCompleted() {
        return this.response != null;
    }

    private boolean hasExceptionInExecution() {
        return this.thrownException != null;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        return this.getResponse(() -> this.response.getPayload());
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getResponse(() -> this.response.getPayload(), timeout, unit);
    }

    @Override
    public Object getErrorResponse() throws InterruptedException, ExecutionException {
        return this.getResponse(() -> this.response.getErrorPayload());
    }

    @Override
    public Object getErrorResponse(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getResponse(() -> this.response.getErrorPayload(), timeout, unit);
    }

    @Override
    public ProcessingContext<Object> getRaw() throws InterruptedException, ExecutionException {
        return this.getResponse(() -> this.response);
    }

    @Override
    public ProcessingContext<Object> getRaw(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getResponse(() -> this.response, timeout, unit);
    }

    private <T> T getResponse(Supplier<T> responseSupplier) throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            this.countDownLatch.await();
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
        }
        if (this.hasExceptionInExecution()) {
            throw new ExecutionException(this.thrownException);
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        return responseSupplier.get();
    }

    private <T> T getResponse(Supplier<T> responseSupplier, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.isDone()) {
            if (!this.countDownLatch.await(timeout, unit)) {
                throw new TimeoutException("Response future timed out");
            }
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (this.hasExceptionInExecution()) {
            throw new ExecutionException(this.thrownException);
        }
        return responseSupplier.get();
    }

    @Override
    public synchronized void then(FollowUpAction followUpAction) {
        if (this.followUpAction != null) {
            throw new UnsupportedOperationException("Then can only be called once.");
        }
        this.followUpAction = followUpAction;
        if (this.isDone()) {
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            if (this.response != null) {
                Object payload = this.response.getPayload();
                Object errorPayload = this.response.getErrorPayload();
                followUpAction.apply(payload, errorPayload, null);
            } else {
                followUpAction.apply(null, null, this.thrownException);
            }
        }
    }

    @Generated
    private ExpectedResponseFuture(SubscriptionContainer subscriptionContainer) {
        this.subscriptionContainer = subscriptionContainer;
    }
}

