/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageBus.internal.exception;

import de.quantummaid.eventmaid.identification.CorrelationId;
import de.quantummaid.eventmaid.messageBus.exception.MessageBusExceptionListener;
import de.quantummaid.eventmaid.messageBus.internal.exception.ExceptionListenerHandler;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;

public class ExceptionListenerHandlerImpl
implements ExceptionListenerHandler {
    private final Map<EventType, List<ListenerInformation>> eventTypeBasedListenerLookupMap = new ConcurrentHashMap<EventType, List<ListenerInformation>>();
    private final Map<CorrelationId, List<ListenerInformation>> correlationIdBasedListenerLookupMap = new ConcurrentHashMap<CorrelationId, List<ListenerInformation>>();
    private final Map<SubscriptionId, ListenerInformation> unregisterLookupMap = new ConcurrentHashMap<SubscriptionId, ListenerInformation>();

    public static ExceptionListenerHandlerImpl errorListenerHandler() {
        return new ExceptionListenerHandlerImpl();
    }

    @Override
    public synchronized SubscriptionId register(EventType eventType, MessageBusExceptionListener exceptionListener) {
        ListenerInformation listenerInformation = new ListenerInformation(eventType, exceptionListener);
        this.storeListenerInformation(eventType, listenerInformation);
        SubscriptionId subscriptionId = SubscriptionId.newUniqueId();
        this.unregisterLookupMap.put(subscriptionId, listenerInformation);
        return subscriptionId;
    }

    @Override
    public synchronized SubscriptionId register(CorrelationId correlationId, MessageBusExceptionListener exceptionListener) {
        ListenerInformation listenerInformation = new ListenerInformation(correlationId, exceptionListener);
        this.storeListenerInformation(correlationId, listenerInformation);
        SubscriptionId subscriptionId = SubscriptionId.newUniqueId();
        this.unregisterLookupMap.put(subscriptionId, listenerInformation);
        return subscriptionId;
    }

    private void storeListenerInformation(EventType eventType, ListenerInformation listenerInformation) {
        if (this.eventTypeBasedListenerLookupMap.containsKey(eventType)) {
            List<ListenerInformation> listenerInformationList = this.eventTypeBasedListenerLookupMap.get(eventType);
            listenerInformationList.add(listenerInformation);
        } else {
            LinkedList<ListenerInformation> listenerList = new LinkedList<ListenerInformation>();
            listenerList.add(listenerInformation);
            this.eventTypeBasedListenerLookupMap.put(eventType, listenerList);
        }
    }

    private void storeListenerInformation(CorrelationId correlationId, ListenerInformation listenerInformation) {
        if (this.correlationIdBasedListenerLookupMap.containsKey(correlationId)) {
            this.correlationIdBasedListenerLookupMap.get(correlationId).add(listenerInformation);
        } else {
            LinkedList<ListenerInformation> listenerInformationList = new LinkedList<ListenerInformation>();
            listenerInformationList.add(listenerInformation);
            this.correlationIdBasedListenerLookupMap.put(correlationId, listenerInformationList);
        }
    }

    @Override
    public synchronized void unregister(SubscriptionId subscriptionId) {
        if (this.unregisterLookupMap.containsKey(subscriptionId)) {
            ListenerInformation listenerInformation = this.unregisterLookupMap.get(subscriptionId);
            this.removeClassBasedListener(listenerInformation);
            this.removeCorrelationIdBasedListener(listenerInformation);
            this.unregisterLookupMap.remove(subscriptionId);
        }
    }

    private void removeClassBasedListener(ListenerInformation listenerInformation) {
        List<EventType> eventTypes = listenerInformation.getRegisteredEventTypes();
        for (EventType eventType : eventTypes) {
            List<ListenerInformation> listenerInformationList = this.eventTypeBasedListenerLookupMap.get(eventType);
            if (listenerInformationList == null) continue;
            listenerInformationList.remove(listenerInformation);
        }
    }

    private void removeCorrelationIdBasedListener(ListenerInformation listenerInformation) {
        List<CorrelationId> correlationIds = listenerInformation.getRegisteredCorrelationIds();
        for (CorrelationId correlationId : correlationIds) {
            List<ListenerInformation> listenerInformationList = this.correlationIdBasedListenerLookupMap.get(correlationId);
            if (listenerInformationList == null) continue;
            listenerInformationList.remove(listenerInformation);
        }
    }

    @Override
    public List<MessageBusExceptionListener> listenerFor(ProcessingContext<?> processingContext) {
        LinkedList<MessageBusExceptionListener> listeners = new LinkedList<MessageBusExceptionListener>();
        CorrelationId correlationId = processingContext.getCorrelationId();
        if (correlationId != null) {
            List<MessageBusExceptionListener> correlationBasedListeners = this.listenerForCorrelationId(correlationId);
            listeners.addAll(correlationBasedListeners);
        }
        EventType eventType = processingContext.getEventType();
        List<MessageBusExceptionListener> classBasedListener = this.listenerForEventType(eventType);
        listeners.addAll(classBasedListener);
        return listeners;
    }

    private List<MessageBusExceptionListener> listenerForEventType(EventType eventType) {
        if (this.eventTypeBasedListenerLookupMap.containsKey(eventType)) {
            List<ListenerInformation> listenerInformationList = this.eventTypeBasedListenerLookupMap.get(eventType);
            List<MessageBusExceptionListener> listener = this.extractListener(listenerInformationList);
            return listener;
        }
        return Collections.emptyList();
    }

    private List<MessageBusExceptionListener> listenerForCorrelationId(CorrelationId correlationId) {
        if (this.correlationIdBasedListenerLookupMap.containsKey(correlationId)) {
            List<ListenerInformation> listenerInformationList = this.correlationIdBasedListenerLookupMap.get(correlationId);
            List<MessageBusExceptionListener> listener = this.extractListener(listenerInformationList);
            return listener;
        }
        return Collections.emptyList();
    }

    private List<MessageBusExceptionListener> extractListener(List<ListenerInformation> listenerInformationList) {
        return listenerInformationList.stream().map(ListenerInformation::getListener).collect(Collectors.toList());
    }

    @Override
    public List<MessageBusExceptionListener> allListener() {
        return this.unregisterLookupMap.values().stream().map(ListenerInformation::getListener).collect(Collectors.toList());
    }

    private static final class ListenerInformation {
        private final List<EventType> registeredEventTypes = new LinkedList<EventType>();
        private final List<CorrelationId> registeredCorrelationIds;
        private final MessageBusExceptionListener listener;

        private <T> ListenerInformation(EventType eventType, MessageBusExceptionListener listener) {
            this.registeredEventTypes.add(eventType);
            this.listener = listener;
            this.registeredCorrelationIds = new LinkedList<CorrelationId>();
        }

        private ListenerInformation(CorrelationId registeredCorrelationId, MessageBusExceptionListener listener) {
            this.listener = listener;
            this.registeredCorrelationIds = new LinkedList<CorrelationId>();
            this.registeredCorrelationIds.add(registeredCorrelationId);
        }

        @Generated
        public List<EventType> getRegisteredEventTypes() {
            return this.registeredEventTypes;
        }

        @Generated
        public List<CorrelationId> getRegisteredCorrelationIds() {
            return this.registeredCorrelationIds;
        }

        @Generated
        public MessageBusExceptionListener getListener() {
            return this.listener;
        }
    }
}

