/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.pipe.transport;

import de.quantummaid.eventmaid.internal.pipe.events.PipeEventListener;
import de.quantummaid.eventmaid.internal.pipe.transport.SynchronousDelivery;
import de.quantummaid.eventmaid.internal.pipe.transport.TransportMechanism;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class SynchronousTransportMechanism<T>
implements TransportMechanism<T> {
    private final PipeEventListener<T> eventListener;
    private final SynchronousDelivery<T> synchronousDelivery;
    private final List<Subscriber<T>> subscribers;

    @Override
    public void transport(T message) {
        this.eventListener.messageAccepted(message);
        this.synchronousDelivery.deliver(message, this.subscribers);
    }

    @Override
    public void close(boolean finishRemainingTasks) {
    }

    @Override
    public boolean isShutdown() {
        return true;
    }

    @Override
    public boolean awaitTermination(int timeout, TimeUnit timeUnit) {
        return true;
    }

    @Generated
    public SynchronousTransportMechanism(PipeEventListener<T> eventListener, SynchronousDelivery<T> synchronousDelivery, List<Subscriber<T>> subscribers) {
        this.eventListener = eventListener;
        this.synchronousDelivery = synchronousDelivery;
        this.subscribers = subscribers;
    }
}

