/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.channel.internal.statistics;

import de.quantummaid.eventmaid.channel.internal.statistics.PartialCollectingChannelStatisticsCollector;
import de.quantummaid.eventmaid.channel.statistics.ChannelStatistics;
import de.quantummaid.eventmaid.internal.pipe.Pipe;
import de.quantummaid.eventmaid.internal.pipe.statistics.PipeStatistics;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public final class PipeStatisticsBasedChannelStatisticsCollector
implements PartialCollectingChannelStatisticsCollector {
    private final Pipe<?> acceptingPipe;
    private final Pipe<?> deliveringPipe;
    private final AtomicLong messagesBlocked = new AtomicLong();
    private final AtomicLong messagesForgotten = new AtomicLong();
    private final AtomicLong exceptionsInFilter = new AtomicLong();

    public static PipeStatisticsBasedChannelStatisticsCollector pipeStatisticsBasedChannelStatisticsCollector(Pipe<?> acceptingPipe, Pipe<?> deliveringPipe) {
        return new PipeStatisticsBasedChannelStatisticsCollector(acceptingPipe, deliveringPipe);
    }

    @Override
    public void informMessageBlocked() {
        this.messagesBlocked.incrementAndGet();
    }

    @Override
    public void informMessageForgotten() {
        this.messagesForgotten.incrementAndGet();
    }

    @Override
    public void informExceptionInFilterThrown() {
        this.exceptionsInFilter.incrementAndGet();
    }

    @Override
    public ChannelStatistics getStatistics() {
        PipeStatistics acceptingStatistics = this.statisticsOf(this.acceptingPipe);
        PipeStatistics deliveringStatistics = this.statisticsOf(this.deliveringPipe);
        BigInteger acceptedMessages = acceptingStatistics.getAcceptedMessages();
        BigInteger queuedMessages = acceptingStatistics.getQueuedMessages();
        BigInteger blockedMessages = this.asBigInt(this.messagesBlocked);
        BigInteger forgottenMessages = this.asBigInt(this.messagesForgotten);
        BigInteger successfulMessages = deliveringStatistics.getSuccessfulMessages();
        BigInteger pipeFailedMessages = deliveringStatistics.getFailedMessages();
        BigInteger deliveryFailedBecauseOfExceptionsInFilter = this.asBigInt(this.exceptionsInFilter);
        BigInteger failedMessages = pipeFailedMessages.add(deliveryFailedBecauseOfExceptionsInFilter);
        Date timestamp = new Date();
        return ChannelStatistics.channelStatistics(timestamp, acceptedMessages, queuedMessages, blockedMessages, forgottenMessages, successfulMessages, failedMessages);
    }

    private PipeStatistics statisticsOf(Pipe<?> pipe) {
        return pipe.getStatusInformation().getCurrentMessageStatistics();
    }

    private BigInteger asBigInt(AtomicLong atomicLong) {
        long value = atomicLong.get();
        return BigInteger.valueOf(value);
    }

    @Generated
    private PipeStatisticsBasedChannelStatisticsCollector(Pipe<?> acceptingPipe, Pipe<?> deliveringPipe) {
        this.acceptingPipe = acceptingPipe;
        this.deliveringPipe = deliveringPipe;
    }
}

