/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageBus;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.ChannelBuilder;
import de.quantummaid.eventmaid.channel.ChannelType;
import de.quantummaid.eventmaid.configuration.AsynchronousConfiguration;
import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.messageBus.MessageBusConsumeAction;
import de.quantummaid.eventmaid.messageBus.MessageBusImpl;
import de.quantummaid.eventmaid.messageBus.MessageBusType;
import de.quantummaid.eventmaid.messageBus.channelCreating.MessageBusChannelFactory;
import de.quantummaid.eventmaid.messageBus.channelCreating.SynchronousMessageBusChannelFactory;
import de.quantummaid.eventmaid.messageBus.exception.ErrorThrowingMessageBusExceptionHandler;
import de.quantummaid.eventmaid.messageBus.exception.MessageBusExceptionHandler;
import de.quantummaid.eventmaid.messageBus.internal.brokering.MessageBusBrokerStrategy;
import de.quantummaid.eventmaid.messageBus.internal.brokering.MessageBusBrokerStrategyImpl;
import de.quantummaid.eventmaid.messageBus.internal.correlationIds.CorrelationBasedSubscriptions;
import de.quantummaid.eventmaid.messageBus.internal.correlationIds.CorrelationBasedSubscriptionsImpl;
import de.quantummaid.eventmaid.messageBus.internal.exception.DelegatingChannelExceptionHandler;
import de.quantummaid.eventmaid.messageBus.internal.exception.ErrorListenerDelegatingMessageBusExceptionHandler;
import de.quantummaid.eventmaid.messageBus.internal.exception.ExceptionListenerHandlerImpl;

public final class MessageBusBuilder {
    private MessageBusChannelFactory channelFactory;
    private MessageBusType type = MessageBusType.SYNCHRONOUS;
    private AsynchronousConfiguration asynchronousConfiguration;
    private MessageBusExceptionHandler exceptionHandler = ErrorThrowingMessageBusExceptionHandler.errorThrowingMessageBusExceptionHandler();

    public static MessageBusBuilder aMessageBus() {
        return new MessageBusBuilder();
    }

    public MessageBusBuilder forType(MessageBusType type) {
        this.type = type;
        return this;
    }

    public MessageBusBuilder withAChannelFactory(MessageBusChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public MessageBusBuilder withAsynchronousConfiguration(AsynchronousConfiguration asynchronousConfiguration) {
        this.asynchronousConfiguration = asynchronousConfiguration;
        return this;
    }

    public MessageBusBuilder withExceptionHandler(MessageBusExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public MessageBus build() {
        ExceptionListenerHandlerImpl errorListenerHandler = ExceptionListenerHandlerImpl.errorListenerHandler();
        MessageBusExceptionHandler exceptionHandler = this.createExceptionHandler(errorListenerHandler);
        MessageBusBrokerStrategy brokerStrategy = this.createBrokerStrategy(exceptionHandler);
        CorrelationBasedSubscriptionsImpl corSubscriptions = CorrelationBasedSubscriptionsImpl.correlationBasedSubscriptions();
        Channel<Object> acceptingChannel = this.createAcceptingChannel(brokerStrategy, exceptionHandler, corSubscriptions);
        return new MessageBusImpl(acceptingChannel, brokerStrategy, corSubscriptions, errorListenerHandler);
    }

    private MessageBusBrokerStrategy createBrokerStrategy(MessageBusExceptionHandler exceptionHandler) {
        MessageBusChannelFactory channelFactory = this.createChannelFactory();
        return MessageBusBrokerStrategyImpl.messageBusBrokerStrategyImpl2(channelFactory, exceptionHandler);
    }

    private MessageBusExceptionHandler createExceptionHandler(ExceptionListenerHandlerImpl errorListenerHandler) {
        return ErrorListenerDelegatingMessageBusExceptionHandler.errorListenerDelegatingMessageBusExceptionHandler(this.exceptionHandler, errorListenerHandler);
    }

    private MessageBusChannelFactory createChannelFactory() {
        if (this.channelFactory == null) {
            return SynchronousMessageBusChannelFactory.synchronousMessageBusChannelFactory();
        }
        return this.channelFactory;
    }

    private Channel<Object> createAcceptingChannel(MessageBusBrokerStrategy brokerStrategy, MessageBusExceptionHandler exceptionHandler, CorrelationBasedSubscriptions correlationBasedSubscriptions) {
        ChannelType channelType = this.map(this.type);
        DelegatingChannelExceptionHandler acceptingPipeExceptionHandler = DelegatingChannelExceptionHandler.delegatingChannelExceptionHandlerForAcceptingChannel(exceptionHandler);
        Channel<Object> acceptingChannel = ChannelBuilder.aChannel(Object.class).forType(channelType).withAsynchronousConfiguration(this.asynchronousConfiguration).withChannelExceptionHandler(acceptingPipeExceptionHandler).withDefaultAction(MessageBusConsumeAction.messageBusConsumeAction(brokerStrategy, correlationBasedSubscriptions)).build();
        acceptingPipeExceptionHandler.setChannel(acceptingChannel);
        return acceptingChannel;
    }

    private ChannelType map(MessageBusType messageBusType) {
        switch (messageBusType) {
            case SYNCHRONOUS: {
                return ChannelType.SYNCHRONOUS;
            }
            case ASYNCHRONOUS: {
                return ChannelType.ASYNCHRONOUS;
            }
        }
        throw new IllegalArgumentException("Unknown type for message bus: " + messageBusType);
    }

    private MessageBusBuilder() {
    }
}

